/*
 * Decompiled with CFR 0.152.
 */
package justmaks19.dev.actionalert;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.TextContainer;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.player.PlayerDeathEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerKickEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.TextFormat;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class ActionAlert
extends PluginBase
implements Listener {
    public static Config config;
    public String join;
    public String quit;
    public String kick;
    public Map death;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info(TextFormat.colorize((String)"&3ActionAlert by justmaks19 loaded successfully!!!"));
        this.getDataFolder().mkdirs();
        config = new Config(new File(this.getDataFolder(), "config.yml"), 2, (LinkedHashMap)new LinkedHashMap<String, Object>(){
            {
                this.put("join-message", "%player% joined to nukkit server");
                this.put("quit-message", "%player% quit to nukkit server");
                this.put("death-message", new LinkedHashMap<String, Object>(){
                    {
                        this.put("pvp", "%player was killed by %killer%");
                        this.put("suicide", "%player% made suicide");
                        this.put("projectile", "%player% was killed by arrow or snowball");
                        this.put("contact", "%player% was killed by cactus");
                        this.put("fire", "%player% was killed by fire");
                        this.put("drowning", "%player% drowning");
                        this.put("lava", "%player% was killed by lava");
                        this.put("explosition", "%player% was killed by TNT");
                        this.put("fall", "%player% fell from a great height");
                    }
                });
            }
        });
        this.join = (String)config.get("join-message");
        this.quit = (String)config.get("quit-message");
        this.kick = (String)config.get("kick-message");
        this.death = (LinkedHashMap)config.get("death-message");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        event.setJoinMessage(TextFormat.colorize((String)this.join.replace("%player%", player.getName())));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        event.setQuitMessage(TextFormat.colorize((String)this.quit.replace("%player%", player.getName())));
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        event.setQuitMessage(TextFormat.colorize((String)this.kick.replace("%player%", player.getName())));
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player entity = event.getEntity();
        EntityDamageEvent damage = entity.getLastDamageCause();
        if (entity instanceof Player) {
            Player player = entity;
            if (damage instanceof EntityDamageByEntityEvent) {
                Entity damager = ((EntityDamageByEntityEvent)damage).getDamager();
                if (damager instanceof Player) {
                    Player killer = (Player)damager;
                    event.setDeathMessage(new TextContainer(this.death.get("pvp").toString().replace("%player%", player.getName()).replace("%killer%", killer.getName())));
                }
            } else if (damage.getCause() == 12) {
                event.setDeathMessage(new TextContainer(this.death.get("suicide").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 2) {
                event.setDeathMessage(new TextContainer(this.death.get("projectile").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 0) {
                event.setDeathMessage(new TextContainer(this.death.get("contact").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 5) {
                event.setDeathMessage(new TextContainer(this.death.get("fire").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 8) {
                event.setDeathMessage(new TextContainer(this.death.get("drowning").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 7) {
                event.setDeathMessage(new TextContainer(this.death.get("lava").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 10) {
                event.setDeathMessage(new TextContainer(this.death.get("explosition").toString().replace("%player%", player.getName())));
            } else if (damage.getCause() == 4) {
                event.setDeathMessage(new TextContainer(this.death.get("fall").toString().replace("%player%", player.getName())));
            }
        }
    }
}

