/*
 * Decompiled with CFR 0.152.
 */
package SimpleAuth;

import SimpleAuth.SimpleAuth;
import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.event.inventory.InventoryPickupArrowEvent;
import cn.nukkit.event.inventory.InventoryPickupItemEvent;
import cn.nukkit.event.player.PlayerDropItemEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerItemConsumeEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerQuitEvent;

public class EventListener
implements Listener {
    private SimpleAuth plugin;

    public EventListener(SimpleAuth plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onBlockBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            p.sendMessage("\u00a7cYou are not logged in.");
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onBlockPlace(BlockPlaceEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            p.sendMessage("\u00a7cYou are not logged in.");
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (this.plugin.provider.isPlayerRegistered(p)) {
            p.sendMessage("\u00a7eThis account is registered\n\u00a7aPlease login using /login <password>");
        } else {
            p.sendMessage("\u00a7aPlease register using /register <password> <password>");
        }
        this.plugin.unauthed.put(p.getName().toLowerCase(), p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            this.plugin.unauthed.remove(p.getName().toLowerCase());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            p.sendMessage("\u00a7cYou are not logged in.");
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onItemConsume(PlayerItemConsumeEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onItemDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.isAuthed(p)) {
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPickupItem(InventoryPickupItemEvent e) {
        if (!(e.getInventory().getHolder() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getInventory().getHolder();
        if (!this.plugin.isAuthed(p)) {
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPickup(InventoryPickupArrowEvent e) {
        if (!(e.getInventory().getHolder() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getInventory().getHolder();
        if (!this.plugin.isAuthed(p)) {
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onHit(EntityDamageEvent e) {
        Entity killer;
        Entity ent = e.getEntity();
        if (ent instanceof Player && !this.plugin.isAuthed((Player)ent)) {
            e.setCancelled();
        } else if (e instanceof EntityDamageByEntityEvent && (killer = ((EntityDamageByEntityEvent)e).getDamager()) instanceof Player && !this.plugin.isAuthed((Player)killer)) {
            ((Player)killer).sendMessage("\u00a7cYou are not logged in.");
            e.setCancelled();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onProjectileLaunch(ProjectileLaunchEvent e) {
        Entity ent = e.getEntity().shootingEntity;
        if (ent instanceof Player && !this.plugin.isAuthed((Player)ent)) {
            e.setCancelled();
        }
    }
}

