/*
 * Decompiled with CFR 0.152.
 */
package SimpleAuth;

import SimpleAuth.EventListener;
import SimpleAuth.Provider.MysqlProvider;
import SimpleAuth.Provider.Provider;
import SimpleAuth.Provider.YamlProvider;
import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class SimpleAuth
extends PluginBase
implements Listener {
    public HashMap<String, Player> unauthed = new HashMap();
    public Provider provider;
    public HashMap<String, String> data = new HashMap();
    private EventListener eventListener;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveResource("config.yml");
        this.initConfig();
        this.setProvider();
        this.eventListener = new EventListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command works in game only");
            return false;
        }
        switch (cmd.getName().toLowerCase()) {
            case "register": {
                if (this.isAuthed((Player)sender) || this.provider.isPlayerRegistered((Player)sender) || this.provider.getPlayer((Player)sender) != null) {
                    sender.sendMessage("\u00a7cYou are already registered.");
                    break;
                }
                if (args.length != 2) {
                    sender.sendMessage("\u00a7cUse /register <password> <password>");
                    break;
                }
                if (!args[0].equals(args[1])) {
                    sender.sendMessage("\u00a7cBoth passwords must be equal!");
                    break;
                }
                String password = this.hash(sender.getName().toLowerCase(), args[0]);
                this.register((Player)sender, password);
                break;
            }
            case "login": {
                if (this.isAuthed((Player)sender)) {
                    sender.sendMessage("\u00a7cYou are already logged in.");
                    break;
                }
                if (!this.provider.isPlayerRegistered((Player)sender) || this.provider.getPlayer((Player)sender) == null) {
                    sender.sendMessage("\u00a7cYou are not registered!");
                    break;
                }
                if (args.length != 1) {
                    sender.sendMessage("\u00a7cUse /login <password>");
                    break;
                }
                this.login((Player)sender, args[0]);
                break;
            }
            case "changepassword": {
                if (args.length == 3) break;
                sender.sendMessage("\u00a7cUse /changepassword <old password> <new password> <new password>");
                break;
            }
            case "unregister": {
                if (args.length == 1) break;
                sender.sendMessage("\u00a7cUse /unregister <password>");
            }
        }
        return true;
    }

    public boolean register(Player p, String pass) {
        if (this.provider.registerPlayer(p, pass) == null) {
            return false;
        }
        this.unauthed.remove(p.getName().toLowerCase());
        p.sendMessage("\u00a7aYou have been authenticated.");
        return true;
    }

    public boolean login(Player p, String pass) {
        Map<String, Object> data = this.provider.getPlayer(p);
        if (data == null) {
            p.sendMessage("\u00a7cError during authentication.");
            return false;
        }
        if (data.get("hash") == null) {
            p.sendMessage("\u00a7cError during authentication.");
            return false;
        }
        if (!data.get("hash").equals(this.hash(p.getName().toLowerCase(), pass))) {
            p.sendMessage("\u00a7cIncorrect password!");
            return false;
        }
        this.unauthed.remove(p.getName().toLowerCase());
        p.sendMessage("\u00a7aYou have been authenticated.");
        return true;
    }

    public boolean unregister(Player p) {
        return true;
    }

    public boolean changePassword(Player p, String oldPass, String newPass) {
        return true;
    }

    public void initConfig() {
        Config cfg = new Config(this.getDataFolder() + "/config.yml");
        this.data.put("dataProvider", ((String)cfg.get("dataProvider", (Object)"yaml")).toLowerCase());
        this.data.put("dataProviderSettings", ((String)cfg.get("dataProviderSettings", (Object)"")).toLowerCase());
        this.data.put("minPasswordLength", (String)cfg.get("minPasswordLength", (Object)"6"));
        this.data.put("maxPasswordLength", (String)cfg.get("maxPasswordLength", (Object)"20"));
        this.data.put("authenticateByLastUniqueId", ((String)cfg.get("authenticateByLastUniqueId", (Object)"false")).toLowerCase());
        this.data.put("authenticateTimeout", (String)cfg.get("authenticateTimeout", (Object)"120"));
    }

    private void setProvider() {
        switch (this.data.get("dataProvider")) {
            case "mysql": {
                this.provider = new MysqlProvider();
                break;
            }
            default: {
                this.provider = new YamlProvider(this);
            }
        }
    }

    private String hash(String salt, String password) {
        String two;
        String one;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
            md.reset();
            md.update((password + salt).getBytes());
            one = new String(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.err);
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-512");
            md.reset();
            md.update((salt + password).getBytes());
            two = new String(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.err);
            return null;
        }
        byte[] sb = one.getBytes();
        byte[] wb = two.getBytes();
        assert (sb.length == wb.length);
        int[] output = new int[sb.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = sb[i] ^ wb[i];
        }
        StringBuilder outb = new StringBuilder();
        for (int bite : output) {
            outb.append(String.format("%2x", bite | 0));
        }
        return outb.toString();
    }

    public boolean isAuthed(Player p) {
        return !this.unauthed.containsKey(p.getName().toLowerCase());
    }
}

