/*
 * Decompiled with CFR 0.152.
 */
package com.fleynaro.advancedkits;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import cn.nukkit.utils.TextFormat;
import com.fleynaro.advancedkits.EventListener;
import com.fleynaro.advancedkits.Kit;
import com.fleynaro.advancedkits.economy.EconomyManager;
import com.fleynaro.advancedkits.lang.LangManager;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Main
extends PluginBase
implements Listener {
    public Map<String, Kit> kits = new HashMap<String, Kit>();
    public EconomyManager economy;
    public boolean permManager = false;
    public LangManager langManager;

    public void onEnable() {
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        this.saveResource("lang/" + this.getServer().getLanguage().getLang().toUpperCase() + ".properties", "/lang.properties", false);
        this.loadKits();
        this.economy = new EconomyManager(this);
        this.langManager = new LangManager(this);
        if (this.getConfig().getBoolean("permissions")) {
            this.permManager = true;
        }
        this.getServer().getScheduler().scheduleRepeatingTask((Plugin)this, new Runnable(){
            private int min = 0;
            private int everyMin = Main.this.getConfig().getInt("autosave");

            @Override
            public void run() {
                for (Kit kit : Main.this.kits.values()) {
                    kit.processCoolDown();
                }
                if (++this.min % this.everyMin == 0) {
                    for (Kit kit : Main.this.kits.values()) {
                        kit.save();
                    }
                }
            }
        }, 1200);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        this.getLogger().info(TextFormat.WHITE + "The plugin " + TextFormat.RED + "AdvancedKits" + TextFormat.WHITE + " has been loaded.");
    }

    public void onDisable() {
        for (Kit kit : this.kits.values()) {
            kit.save();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "kit": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.langManager.getTranslation("in-game"));
                    return true;
                }
                if (args.length == 0) {
                    sender.sendMessage(this.langManager.getTranslation("av-kits", new String[]{this.getKitList()}));
                    return true;
                }
                Kit kit = this.getKit(args[0]);
                if (kit == null) {
                    sender.sendMessage(this.langManager.getTranslation("no-kit", new String[]{args[0]}));
                    return true;
                }
                kit.handleRequest((Player)sender);
                return true;
            }
            case "akreload": {
                for (Map.Entry<String, Kit> entry : this.kits.entrySet()) {
                    entry.getValue().save();
                }
                this.kits = null;
                this.loadKits();
                sender.sendMessage(this.langManager.getTranslation("reload"));
                return true;
            }
        }
        return true;
    }

    private void loadKits() {
        this.saveResource("kits.yml");
        Config cfgKits = new Config(this.getDataFolder() + "/kits.yml", 2);
        for (Map.Entry entry : cfgKits.getAll().entrySet()) {
            this.kits.put((String)entry.getKey(), new Kit(this, (ConfigSection)entry.getValue(), (String)entry.getKey()));
        }
    }

    public String getKitList() {
        String allKits = "";
        for (String kitName : this.kits.keySet()) {
            allKits = allKits + kitName + "|";
        }
        return allKits.substring(0, allKits.length() - 2);
    }

    public Kit getKit(String kit) {
        TreeMap<String, Kit> lowerKeys = new TreeMap<String, Kit>(String.CASE_INSENSITIVE_ORDER);
        lowerKeys.putAll(this.kits);
        if (lowerKeys.containsKey(kit.toLowerCase())) {
            return (Kit)lowerKeys.get(kit.toLowerCase());
        }
        return null;
    }
}

