/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.anyversion;

import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.server.DataPacketReceiveEvent;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import java.lang.reflect.Field;

public class AnyVersion
extends PluginBase
implements Listener {
    private int serverProtocolVersion;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onLoginPacket(DataPacketReceiveEvent event) {
        DataPacket packet = event.getPacket();
        if (packet.pid() != -113) {
            return;
        }
        LoginPacket loginPacket = (LoginPacket)packet;
        if (loginPacket.protocol1 == this.serverProtocolVersion) {
            this.getLogger().info(loginPacket.username + " is using correct protocol version");
        } else {
            this.getLogger().info("\u00a7e" + loginPacket.username + " is using protocol version " + loginPacket.protocol1 + " (server version: " + this.serverProtocolVersion + ")");
            this.getLogger().info("\u00a7cWarning! \u00a7eUsing outdated/outrunning client could damage your server.");
            this.getLogger().info("\u00a7eUse it on your own risk");
            loginPacket.protocol1 = this.serverProtocolVersion;
        }
    }

    public void onEnable() {
        this.serverProtocolVersion = this.getVersion();
        this.getLogger().info("Server protocol version: " + this.serverProtocolVersion);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private int getVersion() {
        try {
            Field f = ProtocolInfo.class.getDeclaredField("CURRENT_PROTOCOL");
            return f.getInt(null);
        }
        catch (Exception e) {
            this.getLogger().info("Failed to detect actual value of server protocol version. Will use precompiled value.");
            return 39;
        }
    }
}

