/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.commands;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.TextFormat;
import ru.nukkit.welcome.commands.CmdDefine;
import ru.nukkit.welcome.commands.Commander;
import ru.nukkit.welcome.util.Message;

public abstract class Cmd {
    private String command;
    private String[] aliases;
    private String[] subCommands;
    private String permission;
    private boolean allowConsole;
    Message description;
    String cmdDesc;

    public Cmd() {
        if (this.getClass().isAnnotationPresent(CmdDefine.class)) {
            CmdDefine cd = this.getClass().getAnnotation(CmdDefine.class);
            this.command = cd.command();
            this.subCommands = cd.subCommands();
            this.permission = cd.permission();
            this.allowConsole = cd.allowConsole();
            this.description = cd.description();
            this.aliases = cd.alias().isEmpty() ? new String[0] : cd.alias().split(",");
        }
    }

    public boolean isCommand(String cmdLabel) {
        if (this.command.equalsIgnoreCase(cmdLabel)) {
            return true;
        }
        if (this.aliases != null) {
            for (String alias : this.aliases) {
                if (!alias.equalsIgnoreCase(cmdLabel)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExecute(CommandSender sender) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            return this.allowConsole;
        }
        if (this.permission == null || this.permission.isEmpty()) {
            return true;
        }
        return player.hasPermission(this.permission);
    }

    public boolean isValidCommand() {
        return this.getCommand() != null && !this.getCommand().isEmpty();
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean checkParams(String[] params) {
        if (this.subCommands == null) {
            return true;
        }
        if (this.subCommands.length == 0) {
            return true;
        }
        if (params.length < this.subCommands.length) {
            return false;
        }
        for (int i = 0; i < this.subCommands.length; ++i) {
            if (params[i].matches(this.subCommands[i])) continue;
            return false;
        }
        return true;
    }

    public boolean executeCommand(CommandSender sender, String[] params) {
        Player player;
        if (!this.checkParams(params)) {
            return false;
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null && !this.allowConsole) {
            return Message.PLAYER_COMMAD_ONLY.print(sender, new Object[0]);
        }
        if (!this.canExecute(sender)) {
            return Message.PERMISSION_FAIL.print(sender, new Object[0]);
        }
        return this.execute(sender, player, params);
    }

    public abstract boolean execute(CommandSender var1, Player var2, String[] var3);

    public String getDescription() {
        return this.description.getText("NOCOLOR");
    }

    public PluginBase getPlugin() {
        return Commander.getPlugin();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getCommand());
        if (this.getAliases().length > 0) {
            String[] ln = this.getAliases();
            sb.append(ln.length > 1 ? " (aliases: " : " (alias: ");
            for (int i = 0; i < ln.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ln[i]);
            }
            sb.append(")");
        }
        if (this.subCommands.length > 0) {
            sb.append(" (sub command: ");
            for (int i = 0; i < this.subCommands.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.subCommands[i]);
            }
            sb.append(")");
        }
        if (this.permission != null && !this.permission.isEmpty()) {
            sb.append(" permission: ").append(this.permission);
        }
        return sb.toString();
    }

    public String getHelpString() {
        return TextFormat.clean((String)("/" + this.getCommand() + (this.subCommands.length > 0 ? " " + Commander.unsplit(this.subCommands) : "") + " - " + this.getDescription()));
    }
}

