/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.password;

import cn.nukkit.Server;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import ru.nukkit.dblib.DbLib;
import ru.nukkit.welcome.Welcome;
import ru.nukkit.welcome.db.LastloginTable;
import ru.nukkit.welcome.db.PasswordsTable;
import ru.nukkit.welcome.password.Password;

public class PasswordDbLib
implements Password {
    private boolean enabled = false;
    ConnectionSource connectionSource;
    Dao<PasswordsTable, String> passDao;
    Dao<LastloginTable, String> lastloginDao;

    public PasswordDbLib() {
        if (Server.getInstance().getPluginManager().getPlugin("DbLib") == null) {
            Welcome.getPlugin().getLogger().info("\u00a7cDbLib plugin not found");
            return;
        }
        this.connectionSource = DbLib.getConnectionSource();
        if (this.connectionSource == null) {
            return;
        }
        try {
            this.passDao = DaoManager.createDao((ConnectionSource)this.connectionSource, PasswordsTable.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, PasswordsTable.class);
            this.lastloginDao = DaoManager.createDao((ConnectionSource)this.connectionSource, LastloginTable.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, LastloginTable.class);
        }
        catch (Exception e) {
            return;
        }
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean checkPassword(String playerName, String password) {
        if (!this.enabled) {
            return false;
        }
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        PasswordsTable pt = null;
        try {
            pt = (PasswordsTable)this.passDao.queryForId((Object)playerName);
        }
        catch (Exception e) {
            return false;
        }
        if (pt.getPassword() == null) {
            return false;
        }
        return password.equals(pt.getPassword());
    }

    public boolean setPassword(String playerName, String password) {
        if (!this.enabled) {
            return false;
        }
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        if (password == null || password.isEmpty()) {
            return false;
        }
        PasswordsTable pt = new PasswordsTable(playerName, password);
        if (pt != null) {
            try {
                this.passDao.create((Object)pt);
            }
            catch (Exception e) {
                pt = null;
            }
        }
        if (pt == null) {
            try {
                pt = (PasswordsTable)this.passDao.queryForId((Object)playerName);
                pt.setPassword(password);
                this.passDao.update((Object)pt);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean hasPassword(String playerName) {
        if (!this.enabled) {
            return false;
        }
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        try {
            return this.passDao.idExists((Object)playerName);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removePassword(String playerName) {
        if (!this.enabled) {
            return false;
        }
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        try {
            PasswordsTable pt = null;
            pt = (PasswordsTable)this.passDao.queryForId((Object)playerName);
            this.passDao.delete((Object)pt);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean checkAutoLogin(String playerName, String uuid, String ip) {
        if (!this.enabled) {
            return false;
        }
        long loginTime = System.currentTimeMillis();
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        String prevIp = "";
        String prevUUID = "";
        long prevTime = 0L;
        LastloginTable llt = null;
        try {
            llt = (LastloginTable)this.lastloginDao.queryForId((Object)playerName);
            prevIp = llt.getIp();
            prevUUID = llt.getUuid();
            prevTime = llt.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loginTime - prevTime > Welcome.getPlugin().getMaxAutoTime()) {
            return false;
        }
        if (prevIp.isEmpty() || prevUUID.isEmpty()) {
            return false;
        }
        if (!prevUUID.equalsIgnoreCase(uuid)) {
            return false;
        }
        return prevIp.equalsIgnoreCase(ip);
    }

    public void updateAutoLogin(String playerName, String uuid, String ip) {
        this.updateAutoLogin(playerName, uuid, ip, System.currentTimeMillis());
    }

    public void updateAutoLogin(String playerName, String uuid, String ip, long currentTime) {
        if (!this.enabled) {
            return;
        }
        if (playerName == null || playerName.isEmpty()) {
            return;
        }
        LastloginTable llt = null;
        try {
            llt = (LastloginTable)this.lastloginDao.queryForId((Object)playerName);
            llt.setUuid(uuid);
            llt.setIp(ip);
            llt.setTime(currentTime);
            this.lastloginDao.update((Object)llt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (llt == null) {
            try {
                this.lastloginDao.create((Object)new LastloginTable(playerName, uuid, ip, currentTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

