/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.password;

import cn.nukkit.utils.Config;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ru.nukkit.welcome.Welcome;
import ru.nukkit.welcome.password.Password;

public class PasswordYaml
implements Password {
    private Map<String, String> passwords = new HashMap<String, String>();
    private Map<String, LoginState> logins = new HashMap<String, LoginState>();

    public PasswordYaml() {
        this.load();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean checkPassword(String playerName, String password) {
        if (!this.passwords.containsKey(playerName)) {
            return false;
        }
        return this.passwords.get(playerName).equals(password);
    }

    public boolean setPassword(String playerName, String password) {
        this.passwords.put(playerName, password);
        this.save();
        return true;
    }

    public boolean hasPassword(String playerName) {
        return this.passwords.containsKey(playerName);
    }

    public boolean removePassword(String playerName) {
        if (!this.passwords.containsKey(playerName)) {
            return false;
        }
        this.passwords.remove(playerName);
        this.save();
        return true;
    }

    public boolean checkAutoLogin(String playerName, String uuid, String ip) {
        LoginState prevLogin;
        long loginTime = System.currentTimeMillis();
        LoginState loginState = prevLogin = this.logins.containsKey(playerName) ? this.logins.get(playerName) : null;
        if (prevLogin == null) {
            return false;
        }
        LoginState newLogin = new LoginState(uuid, ip, loginTime);
        if (!prevLogin.uuid.equalsIgnoreCase(newLogin.uuid)) {
            return false;
        }
        if (!prevLogin.ip.equalsIgnoreCase(newLogin.ip)) {
            return false;
        }
        return newLogin.time - prevLogin.time <= Welcome.getPlugin().getMaxAutoTime();
    }

    public void updateAutoLogin(String playerName, String uuid, String ip) {
        this.updateAutoLogin(playerName, uuid, ip, System.currentTimeMillis());
    }

    public void updateAutoLogin(String playerName, String uuid, String ip, long currentTime) {
        LoginState newLogin = new LoginState(uuid, ip, currentTime);
        this.logins.put(playerName, newLogin);
        this.save();
    }

    private void save() {
        try {
            File dir = Welcome.getPlugin().getDataFolder();
            dir.mkdirs();
            File f = new File(dir, "passwords.yml");
            if (f.exists()) {
                f.delete();
            }
            Config cfg = new Config(f, 2);
            for (String password : this.passwords.keySet()) {
                cfg.set(password, (Object)this.passwords.get(password));
            }
            cfg.save();
            f = new File(dir, "lastlogin.yml");
            if (f.exists()) {
                f.delete();
            }
            cfg = new Config(f, 2);
            for (String key : this.logins.keySet()) {
                LoginState ls = this.logins.get(key);
                cfg.set(key + ".uuid", (Object)ls.uuid);
                cfg.set(key + ".ip", (Object)ls.ip);
                cfg.set(key + ".time", (Object)ls.time);
            }
            cfg.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load() {
        try {
            File dir = Welcome.getPlugin().getDataFolder();
            dir.mkdirs();
            File f = new File(dir, "passwords.yml");
            if (!f.exists()) {
                f.createNewFile();
            }
            Config cfg = new Config(f, 2);
            this.passwords = new HashMap<String, String>();
            for (String key : cfg.getAll().keySet()) {
                this.passwords.put(key, cfg.getString(key));
            }
            f = new File(dir, "lastlogin.yml");
            if (!f.exists()) {
                f.createNewFile();
            }
            cfg = new Config(f, 2);
            this.logins = new HashMap<String, LoginState>();
            HashSet<String> usedKeys = new HashSet<String>();
            for (String key : cfg.getAll().keySet()) {
                String k;
                if (!key.contains(".") || usedKeys.contains(k = key.split(".")[0])) continue;
                usedKeys.add(k);
                String uuid = cfg.getString(key + ".uuid");
                String ip = cfg.getString(key + ".uuid");
                long time = cfg.getLong(key + ".time");
                this.logins.put(k, new LoginState(uuid, ip, time));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class LoginState {
        String uuid;
        String ip;
        long time;

        LoginState(String uuid, String ip, long time) {
            this.uuid = uuid;
            this.ip = ip;
            this.time = time;
        }
    }
}

