/*
 * Decompiled with CFR 0.152.
 */
package net.eqozqq.BanItem;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerDropItemEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerItemHeldEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.item.Item;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BanItem
extends PluginBase
implements Listener {
    private Config config;
    private Set<Integer> bannedItems;
    private boolean autoRemove;
    private Map<String, List<Item>> playerBannedItems = new HashMap<String, List<Item>>();
    private boolean loggingEnabled;
    private File logFile;

    public void onEnable() {
        this.getDataFolder().mkdirs();
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
            this.config = new Config(configFile, 2);
            this.config.set("loggingEnabled", (Object)false);
            this.config.save();
        } else {
            this.config = new Config(configFile, 2);
        }
        this.bannedItems = new HashSet<Integer>(this.config.getList("bannedItems", new ArrayList()));
        this.loggingEnabled = this.config.getBoolean("loggingEnabled", true);
        if (!this.config.exists("autoRemove")) {
            this.config.set("autoRemove", (Object)false);
            this.config.save();
        }
        this.autoRemove = this.config.getBoolean("autoRemove", false);
        if (this.loggingEnabled) {
            this.logFile = new File(this.getDataFolder(), "logging.log");
            if (!this.logFile.exists()) {
                try {
                    this.logFile.createNewFile();
                }
                catch (IOException e) {
                    this.getLogger().error("Failed to create logging.log file: " + e.getMessage());
                }
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void log(String message) {
        if (this.loggingEnabled) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = sdf.format(new Date());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (PrintWriter writer = new PrintWriter(new FileWriter(this.logFile, true));){
                    writer.println("[" + timestamp + "] " + message);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.getLogger().error("Failed to write to logging.log file: " + e.getMessage());
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("item")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
                sender.sendMessage("Blocked items: " + this.bannedItems);
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("ban")) {
                try {
                    int itemId = Integer.parseInt(args[1]);
                    if (!this.bannedItems.contains(itemId)) {
                        this.bannedItems.add(itemId);
                        this.config.set("bannedItems", new ArrayList<Integer>(this.bannedItems));
                        this.config.save();
                        sender.sendMessage("Item " + Item.get((int)itemId).getName() + " (ID: " + itemId + ") blocked.");
                    } else {
                        sender.sendMessage("Item " + Item.get((int)itemId).getName() + " (ID: " + itemId + ") already blocked.");
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("Invalid item ID format.");
                }
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("unban")) {
                try {
                    int itemId = Integer.parseInt(args[1]);
                    if (this.bannedItems.contains(itemId)) {
                        this.bannedItems.remove(itemId);
                        this.config.set("bannedItems", new ArrayList<Integer>(this.bannedItems));
                        this.config.save();
                        sender.sendMessage("Item " + Item.get((int)itemId).getName() + " (ID: " + itemId + ") unblocked.");
                    } else {
                        sender.sendMessage("Item " + Item.get((int)itemId).getName() + " (ID: " + itemId + ") was not blocked.");
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("Invalid item ID format.");
                }
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("autoremove")) {
                this.autoRemove = Boolean.parseBoolean(args[1]);
                this.config.set("autoRemove", (Object)this.autoRemove);
                this.config.save();
                sender.sendMessage("The 'Remove item from inventory' option is set to: " + this.autoRemove);
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        if (item != null && this.bannedItems.contains(item.getId())) {
            player.sendMessage("\u00a7cYou cannot use this item because it is blocked.");
            event.setCancelled();
            this.log("Player " + player.getName() + " trying to use a blocked item " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ").");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.autoRemove) {
            ArrayList<Item> bannedItemsToRemove = new ArrayList<Item>();
            for (Item item : player.getInventory().getContents().values()) {
                if (item == null || !this.bannedItems.contains(item.getId())) continue;
                bannedItemsToRemove.add(item);
            }
            for (Item item : bannedItemsToRemove) {
                player.getInventory().remove(item);
                player.sendMessage("\u00a7cBlocked item removed " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ") from your inventory.");
                this.log("Player " + player.getName() + " has a blocked item " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ").");
            }
            this.playerBannedItems.put(player.getName(), bannedItemsToRemove);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.autoRemove) {
            this.playerBannedItems.remove(player.getName());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        if (item != null && this.bannedItems.contains(item.getId())) {
            player.sendMessage("\u00a7cYou cannot throw away this item because it is blocked.");
            event.setCancelled();
            this.log("Player " + player.getName() + " tries to throw away a blocked item " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ").");
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        Item item = player.getInventory().getItem(event.getInventorySlot());
        if (this.autoRemove && item != null && this.bannedItems.contains(item.getId())) {
            player.getInventory().setItem(event.getInventorySlot(), Item.get((int)0));
            player.sendMessage("\u00a7cBlocked item removed " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ") from your inventory.");
            this.log("Player " + player.getName() + " trying to use a blocked item " + Item.get((int)item.getId()).getName() + " (ID: " + item.getId() + ").");
        }
    }
}

