/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.autonotice;

import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.PluginTask;
import cn.nukkit.utils.Utils;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.to2mbn.basiscommands.BasisCommands;
import org.to2mbn.basiscommands.util.PluginUtils;

public class AutoNoticeHandler
extends PluginTask<BasisCommands> {
    protected final List<String> noticeList;
    protected final File noticeFile;
    protected final Random rand = new Random(System.currentTimeMillis());
    protected final int delay;
    private int lastTick = 1;

    public AutoNoticeHandler(BasisCommands owner, File _noticeFile, int _delay) {
        super((Plugin)owner);
        this.noticeList = Collections.synchronizedList(Lists.newArrayList());
        this.noticeFile = _noticeFile;
        this.delay = _delay;
        try {
            this.loadNotices();
        }
        catch (JsonSyntaxException | IOException e) {
            BasisCommands.logger().error("Failed to load notices");
            e.printStackTrace();
        }
    }

    public void loadNotices() throws IOException, JsonSyntaxException {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(this.noticeFile));){
            reader.setLenient(true);
            JsonArray notices = new JsonParser().parse(reader).getAsJsonArray();
            for (JsonElement notice : notices) {
                this.addNotice(notice.getAsString());
            }
        }
    }

    public void saveNotices() throws IOException {
        JsonArray array = new JsonArray();
        this.noticeList.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        Utils.writeFile((File)this.noticeFile, (String)array.toString());
    }

    public void addNotice(String notice) {
        this.noticeList.add(notice);
    }

    public void removeNotice(int index) {
        this.noticeList.remove(index);
    }

    public void triggerNotice() {
        if (this.noticeList.size() < 1) {
            return;
        }
        String notice = PluginUtils.colorize(this.noticeList.get(this.rand.nextInt(this.noticeList.size())));
        PluginUtils.boardcastMessage(notice);
    }

    public void onRun(int tick) {
        if ((tick - this.lastTick) / 20 >= this.delay) {
            this.triggerNotice();
            this.lastTick = tick;
        }
    }

    public List<String> getNoticeList() {
        return this.noticeList;
    }
}

