/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.configuration;

import cn.nukkit.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    private final File configFile;
    private final Map<String, Object> datas;
    private final Yaml yaml;

    public Configuration(File _configFile) throws IOException {
        this.configFile = _configFile;
        this.datas = new HashMap<String, Object>();
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(dumperOptions);
        this.datas.putAll((Map)this.yaml.loadAs(Utils.readFile((File)this.configFile), LinkedHashMap.class));
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public <T> T get(String key) {
        if (!this.datas.containsKey(key)) {
            return null;
        }
        return (T)this.datas.get(key);
    }

    public boolean has(String key) {
        return this.datas.containsKey(key);
    }
}

