/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.teleportrequest;

import cn.nukkit.Player;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.PluginTask;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.to2mbn.basiscommands.BasisCommands;
import org.to2mbn.basiscommands.teleportrequest.TeleportRequest;

public class TeleportRequestsHandler
extends PluginTask<BasisCommands> {
    protected final Set<TeleportRequest> requests;
    private final int waitTick;
    private int currentTick = 0;

    public TeleportRequestsHandler(BasisCommands owner, int maxWaitSeconds) {
        super((Plugin)owner);
        this.waitTick = 20 * maxWaitSeconds;
        this.requests = Collections.synchronizedSet(Sets.newHashSet());
    }

    public TeleportRequest pickRequest(Player targetPlayer) {
        for (TeleportRequest request : this.requests) {
            if (!request.getTargetPlayer().getName().equals(targetPlayer.getName())) continue;
            this.cancelRequest(request);
            return request;
        }
        return null;
    }

    public void addRequest(TeleportRequest request) {
        if (this.requests.contains(request)) {
            this.requests.remove(request);
        }
        this.requests.add(request);
    }

    public void cancelRequest(TeleportRequest request) {
        this.requests.remove(request);
    }

    public void onRun(int tick) {
        this.currentTick = tick;
        for (TeleportRequest request : this.requests) {
            int requestTime;
            if (request == null || this.currentTick - (requestTime = request.getTime()) < this.waitTick) continue;
            this.cancelRequest(request);
        }
    }
}

