/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.command;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;
import org.to2mbn.basiscommands.BasisCommands;
import org.to2mbn.basiscommands.command.Command;
import org.to2mbn.basiscommands.i18n.I18n;
import org.to2mbn.basiscommands.teleportposition.TeleportPositionsHandler;
import org.to2mbn.basiscommands.teleportposition.position.HomePointPosition;
import org.to2mbn.basiscommands.util.PluginUtils;
import org.to2mbn.basiscommands.util.command.CommandArgumentTemplet;
import org.to2mbn.basiscommands.util.command.CommandArguments;

public class CommandHome
implements Command {
    @Override
    public String getName() {
        return "home";
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        return sender instanceof Player;
    }

    @Override
    public CommandArgumentTemplet<?>[] getArgumentTemplets() {
        return new CommandArgumentTemplet[]{new CommandArgumentTemplet<String>(String.class, false)};
    }

    @Override
    public void execute(CommandSender sender, CommandArguments args) {
        Player player = (Player)sender;
        if (!args.hasNext()) {
            PluginUtils.sendMessage((CommandSender)player, I18n.translate("command.homelist.homes"));
            BasisCommands.getTeleportPositionsHandler().getPlayerHomePositions(player).forEach(position -> PluginUtils.sendMessage((CommandSender)player, this.toDisplayString((HomePointPosition)position)));
        } else {
            String homeName = args.nextString();
            TeleportPositionsHandler handler = BasisCommands.getTeleportPositionsHandler();
            HomePointPosition homePosition = handler.getHomePointPositionByName(player, homeName);
            if (homePosition != null) {
                Position position2 = homePosition.toPosition();
                BasisCommands.logger().info("Teleporting player '" + player.getName() + "' to his home:" + position2.getX() + "," + position2.getY() + "," + position2.getZ());
                PluginUtils.sendMessage((CommandSender)player, I18n.format("command.home.teleport_msg", homePosition.getName()));
                player.teleport((Vector3)position2);
            } else {
                PluginUtils.sendMessage((CommandSender)player, I18n.translate("command.home.home_not_exists_msg"));
            }
        }
    }

    private String toDisplayString(HomePointPosition position) {
        return "\u00a76" + position.getName() + "\u00a7f" + " - " + String.format("%s(%s,%s,%s)", Server.getInstance().getLevel(position.getLevel()).getName(), (int)position.getX(), (int)position.getY(), (int)position.getZ());
    }
}

