/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.teleportposition;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.math.Vector3;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.to2mbn.basiscommands.BasisCommands;
import org.to2mbn.basiscommands.teleportposition.position.HomePointPosition;
import org.to2mbn.basiscommands.teleportposition.position.TeleportPointPosition;
import org.to2mbn.basiscommands.teleportposition.position.WarpPointPosition;

public class TeleportPositionsHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File positionsFile;
    private final List<WarpPointPosition> warpPositions;
    private final Map<Integer, TeleportPointPosition> spawnPositions = new HashMap<Integer, TeleportPointPosition>();
    private final Map<String, List<HomePointPosition>> homePositions;
    private final Map<String, TeleportPointPosition> backPositions;

    public TeleportPositionsHandler(File _dataFile) throws IOException, ClassNotFoundException {
        this.warpPositions = new ArrayList<WarpPointPosition>();
        this.homePositions = new HashMap<String, List<HomePointPosition>>();
        this.backPositions = new HashMap<String, TeleportPointPosition>();
        this.positionsFile = _dataFile;
        if (this.positionsFile.exists()) {
            try {
                this.loadData();
                return;
            }
            catch (JsonSyntaxException ex) {
                BasisCommands.logger().error("Invalid positions data file");
                ex.printStackTrace();
                this.positionsFile.delete();
            }
        } else {
            BasisCommands.logger().info("Positions data file does not exists");
        }
        this.positionsFile.createNewFile();
        this.loadLevelSpawnPoints();
        this.saveData();
    }

    private void loadLevelSpawnPoints() {
        Server.getInstance().getLevels().forEach((id, level) -> this.spawnPositions.put((Integer)id, TeleportPointPosition.fromPosition(level.getSpawnLocation())));
    }

    public void loadData() throws IOException, JsonSyntaxException {
        JsonObject obj = null;
        try (FileReader reader = new FileReader(this.positionsFile);){
            obj = new JsonParser().parse((Reader)reader).getAsJsonObject();
        }
        this.warpPositions.addAll((Collection)this.gson.fromJson(obj.get("warpPointPositions"), this.warpPositions.getClass()));
        this.spawnPositions.putAll((Map)this.gson.fromJson(obj.get("spawnPointPositions"), this.spawnPositions.getClass()));
        this.homePositions.putAll((Map)this.gson.fromJson(obj.get("homePointPositions"), this.homePositions.getClass()));
        this.backPositions.putAll((Map)this.gson.fromJson(obj.get("backPointPositions"), this.backPositions.getClass()));
    }

    public void saveData() throws IOException {
        JsonObject obj = new JsonObject();
        obj.add("warpPointPositions", this.gson.toJsonTree(this.warpPositions, this.warpPositions.getClass()));
        obj.add("spawnPointPositions", this.gson.toJsonTree(this.spawnPositions, this.spawnPositions.getClass()));
        obj.add("homePointPositions", this.gson.toJsonTree(this.homePositions, this.homePositions.getClass()));
        obj.add("backPointPositions", this.gson.toJsonTree(this.backPositions, this.backPositions.getClass()));
        try (FileWriter writer = new FileWriter(this.positionsFile);){
            writer.write(this.gson.toJson((JsonElement)obj));
        }
    }

    public void addHomePointPosition(Player player, HomePointPosition position) {
        String playerName = player.getName();
        if (!this.homePositions.containsKey(playerName)) {
            this.homePositions.put(playerName, Lists.newArrayList());
        }
        this.homePositions.get(playerName).add(position);
    }

    public void removeHomePointPosition(Player player, String homeName) {
        HomePointPosition position = this.getHomePointPositionByName(player, homeName);
        if (position != null) {
            this.removeHomePointPosition(player, position);
        }
    }

    public void removeHomePointPosition(Player player, HomePointPosition position) {
        this.getPlayerHomePositions(player).remove(position);
    }

    public boolean hasHomePointPosition(Player player, String homeName) {
        return this.getPlayerHomePositions(player).stream().anyMatch(position -> position.getName().equalsIgnoreCase(homeName));
    }

    public List<HomePointPosition> getPlayerHomePositions(Player player) {
        ArrayList positions = this.homePositions.get(player.getName());
        return positions != null ? positions : Lists.newArrayList();
    }

    public HomePointPosition getHomePointPositionByName(Player player, String name) {
        for (HomePointPosition position : this.getPlayerHomePositions(player)) {
            if (!position.getName().equals(name)) continue;
            return position;
        }
        return null;
    }

    public int getHomePointCount(Player player) {
        return this.getPlayerHomePositions(player).size();
    }

    public void setSpawnPointPosition(Level level, Vector3 vector3) {
        level.setSpawnLocation(vector3);
        this.spawnPositions.put(level.getId(), new TeleportPointPosition(vector3.getX(), vector3.getY(), vector3.getZ(), level.getId()));
    }

    public TeleportPointPosition getSpawnPointPosition(int levelId) {
        return this.spawnPositions.get(levelId);
    }

    public TeleportPointPosition getSpawnPointPosition(Level level) {
        return this.getSpawnPointPosition(level.getId());
    }

    public void addWarpPointPosition(WarpPointPosition position) {
        this.warpPositions.add(position);
    }

    public void removeWarpPointPosition(int id) {
        this.warpPositions.remove(id);
    }

    public void removeWarpPointPosition(WarpPointPosition position) {
        this.warpPositions.remove(position);
    }

    public boolean hasWarpPointPosition(String name) {
        return this.warpPositions.stream().anyMatch(position -> position.getName().equalsIgnoreCase(name));
    }

    public WarpPointPosition getWarpPointPosition(String name) {
        for (WarpPointPosition position : this.warpPositions) {
            if (!position.getName().equalsIgnoreCase(name)) continue;
            return position;
        }
        return null;
    }

    public void updatePlayerBackPointPosition(Player player, TeleportPointPosition position) {
        this.backPositions.put(player.getName(), position);
    }

    public TeleportPointPosition getPlayerBackPointPosition(Player player) {
        return this.backPositions.get(player.getName());
    }

    public File getPositionsFile() {
        return this.positionsFile;
    }

    public List<WarpPointPosition> getWarpPositions() {
        return this.warpPositions;
    }

    public Map<Integer, TeleportPointPosition> getSpawnPositions() {
        return this.spawnPositions;
    }

    public Map<String, List<HomePointPosition>> getHomePositions() {
        return this.homePositions;
    }

    public Map<String, TeleportPointPosition> getBackPositions() {
        return this.backPositions;
    }
}

