/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.teleportposition.position;

import cn.nukkit.Server;
import cn.nukkit.level.Position;
import java.util.Objects;

public class TeleportPointPosition {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final int level;

    public TeleportPointPosition(double x, double y, double z, int level) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = level;
    }

    public static TeleportPointPosition fromPosition(Position position) {
        return new TeleportPointPosition(position.getX(), position.getY(), position.getZ(), position.getLevel().getId());
    }

    public Position toPosition() {
        return new Position(this.x, this.y, this.z, Server.getInstance().getLevel(this.level));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportPointPosition that = (TeleportPointPosition)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.level);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TeleportPosition{");
        sb.append("x=").append(this.x);
        sb.append(", y=").append(this.y);
        sb.append(", z=").append(this.z);
        sb.append(", level=").append(this.level);
        sb.append('}');
        return sb.toString();
    }
}

