/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.util;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.to2mbn.basiscommands.BasisCommands;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static boolean isPlayerFirstJoinServer(Player player) {
        String dataFileName = player.getName().toLowerCase() + ".dat";
        File playerDatasDir = new File(Server.getInstance().getDataPath(), "players");
        if (playerDatasDir.exists()) {
            return !Arrays.stream(playerDatasDir.listFiles()).anyMatch(file -> file.getName().equalsIgnoreCase(dataFileName));
        }
        return true;
    }

    public static int getServerTick() {
        return Server.getInstance().getTick();
    }

    public static <T> List<T> arrayToList(T[] array) {
        ArrayList list = Lists.newArrayList();
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static void sendMessage(CommandSender commandSender, String msg) {
        commandSender.sendMessage(PluginUtils.colorize(msg));
    }

    public static void boardcastMessage(String msg) {
        Server.getInstance().getOnlinePlayers().values().forEach(player -> player.sendMessage(msg));
        BasisCommands.logger().info(msg);
    }

    public static String colorize(String message) {
        if (message == null) {
            return "";
        }
        char[] msg = message.toCharArray();
        boolean prefix = false;
        for (int i = 0; i < msg.length; ++i) {
            if (msg[i] == '&' && i < msg.length - 1) {
                prefix = true;
                continue;
            }
            if (!prefix) continue;
            if ("0123456789AaBbCcDdEeFfKkLlMmNnOoRr".contains(msg[i] + "")) {
                msg[i - 1] = 167;
            }
            prefix = false;
        }
        return new String(msg);
    }
}

