/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.basiscommands.util.command;

import cn.nukkit.command.CommandSender;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import org.to2mbn.basiscommands.command.Command;
import org.to2mbn.basiscommands.i18n.I18n;
import org.to2mbn.basiscommands.util.PluginUtils;
import org.to2mbn.basiscommands.util.command.CommandArgumentTemplet;
import org.to2mbn.basiscommands.util.command.CommandArguments;

public class CommandHandler {
    private final Set<Command> commands = Sets.newHashSet();

    public void registerCommand(Command command) {
        this.commands.add(command);
    }

    public Command getCommandByName(String name) {
        for (Command command : this.commands) {
            if (!command.getName().equalsIgnoreCase(name)) continue;
            return command;
        }
        return null;
    }

    public boolean pushCommand(CommandSender sender, String label, String[] args) {
        Command command = this.getCommandByName(label);
        CommandArgumentTemplet[] templets = command.getArgumentTemplets();
        if (command != null) {
            CommandArgumentTemplet templet = this.checkInvalidArgument(templets, args);
            if (templet != null) {
                sender.sendMessage(templet.getInfo());
                return false;
            }
            if (command.canExecute(sender)) {
                command.execute(sender, this.toCommandArguments(templets, args));
            } else {
                PluginUtils.sendMessage(sender, I18n.translate("command.not_allowed_to_use_msg"));
            }
            return true;
        }
        return false;
    }

    private CommandArguments toCommandArguments(CommandArgumentTemplet[] templets, String[] args) {
        ArrayList list = Lists.newArrayList();
        block13: for (int i = 0; i < templets.length; ++i) {
            CommandArgumentTemplet templet = templets[i];
            if (i >= args.length && !templet.isRequired()) continue;
            String arg = args[i];
            switch (templet.getType().getSimpleName().toLowerCase()) {
                case "int": 
                case "integer": {
                    list.add(Integer.parseInt(arg));
                    continue block13;
                }
                case "double": {
                    list.add(Double.parseDouble(arg));
                    continue block13;
                }
                case "boolean": {
                    list.add(Boolean.parseBoolean(arg));
                    continue block13;
                }
                case "string": {
                    list.add(arg);
                    continue block13;
                }
            }
        }
        return new CommandArguments(list.iterator());
    }

    private CommandArgumentTemplet checkInvalidArgument(CommandArgumentTemplet[] templets, String[] args) {
        block13: for (int i = 0; i < templets.length; ++i) {
            CommandArgumentTemplet templet = templets[i];
            if (i >= args.length) {
                if (!templet.isRequired()) continue;
                return templet;
            }
            String arg = args[i];
            Function<Object, Boolean> isValidFunc = templet.getIsValid();
            switch (templet.getType().getSimpleName().toLowerCase()) {
                case "int": 
                case "integer": {
                    if (this.canConvertIntoInteger(arg) && isValidFunc.apply(Integer.parseInt(arg)).booleanValue()) continue block13;
                    return templet;
                }
                case "double": {
                    if (this.canConvertIntoDouble(arg) && isValidFunc.apply(Double.parseDouble(arg)).booleanValue()) continue block13;
                    return templet;
                }
                case "boolean": {
                    if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false")) continue block13;
                    return templet;
                }
                case "string": {
                    if (isValidFunc.apply(arg).booleanValue()) continue block13;
                    return templet;
                }
                default: {
                    return templet;
                }
            }
        }
        return null;
    }

    private boolean canConvertIntoInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean canConvertIntoDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

