/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders;

import cn.nukkit.Player;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ru.nukkit.borders.Border;
import ru.nukkit.borders.BordersPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Borders {
    private static Map<String, Border> borders = new TreeMap<String, Border>(String.CASE_INSENSITIVE_ORDER);

    public static void init() {
        Borders.load();
    }

    public static void load() {
        BordersPlugin.getPlugin().getDataFolder().mkdirs();
        File f = new File(BordersPlugin.getPlugin().getDataFolder() + File.separator + "borders.yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Config cfg = new Config(f, 2);
        for (String key : cfg.getAll().keySet()) {
            String value;
            if (key.contains(".") || (value = (String)cfg.getNested(key, (Object)"")) == null || value.isEmpty() || !value.matches("\\S+,\\s*\\d+,\\s*\\d+,\\s*\\d+,\\s*\\d+")) continue;
            String[] ln = value.split(",\\s*");
            Border border = new Border(ln[0], Integer.parseInt(ln[1]), Integer.parseInt(ln[2]), Integer.parseInt(ln[3]), Integer.parseInt(ln[4]));
            borders.put(key, border);
        }
    }

    public static void save() {
        File f = new File(BordersPlugin.getPlugin().getDataFolder() + File.separator + "borders.yml");
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Config cfg = new Config(f, 2);
        for (String key : borders.keySet()) {
            Border b = borders.get(key);
            cfg.setNested(key, (Object)b.toString());
        }
        cfg.save();
    }

    public static void add(String id, Border border) {
        borders.put(id, border);
        Borders.save();
    }

    public static void add(String id, Location loc1, Location loc2) {
        Borders.add(id, new Border(loc1, loc2));
    }

    public static List<Border> getBorderInWorld(Level level) {
        ArrayList<Border> brd = new ArrayList<Border>();
        for (Border b : borders.values()) {
            if (!b.world.equalsIgnoreCase(level.getName())) continue;
            brd.add(b);
        }
        return brd;
    }

    public static boolean allowedLocation(Player player, Location location) {
        List<Border> brd = Borders.getBorderInWorld(player.getLevel());
        if (brd.isEmpty()) {
            return true;
        }
        for (Border b : brd) {
            if (!b.isLocInBorder(location)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getBorderList() {
        return Borders.getBorderList(borders);
    }

    public static List<String> getBorderList(Map<String, Border> borders) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String key : borders.keySet()) {
            lst.add("\u00a7a" + key + " : " + "\u00a72" + borders.get(key).toPrintString());
        }
        return lst;
    }

    public static boolean exist(String id) {
        return borders.containsKey(id);
    }

    public static void remove(String id) {
        if (borders.containsKey(id)) {
            borders.containsKey(id);
        }
    }

    public static Map<String, Border> getBordersInLoc(Location location) {
        HashMap<String, Border> brd = new HashMap<String, Border>();
        for (String key : borders.keySet()) {
            Border b = borders.get(key);
            if (!b.isLocInBorder(location)) continue;
            brd.put(key, b);
        }
        return brd;
    }
}

