/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders.commands;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.plugin.PluginBase;
import java.util.ArrayList;
import java.util.List;
import ru.nukkit.borders.commands.Cmd;
import ru.nukkit.borders.commands.CmdAddBorder;
import ru.nukkit.borders.commands.CmdBrdSelect;
import ru.nukkit.borders.commands.CmdBrdSelectCoord;
import ru.nukkit.borders.commands.CmdCheck;
import ru.nukkit.borders.commands.CmdHelp;
import ru.nukkit.borders.commands.CmdList;
import ru.nukkit.borders.commands.CmdReload;
import ru.nukkit.borders.commands.CmdRemove;
import ru.nukkit.borders.commands.CmdWalker;
import ru.nukkit.borders.commands.CommandExecutor;
import ru.nukkit.borders.util.Message;
import ru.nukkit.borders.util.Paginator;

public class Commander {
    private static List<Cmd> commands = new ArrayList<Cmd>();
    private static PluginBase plugin;

    public static void init(PluginBase plg) {
        plugin = plg;
        Commander.addNewCommand(new CmdBrdSelect(), Message.CMD_BRD);
        Commander.addNewCommand(new CmdBrdSelectCoord());
        Commander.addNewCommand(new CmdAddBorder());
        Commander.addNewCommand(new CmdList());
        Commander.addNewCommand(new CmdReload());
        Commander.addNewCommand(new CmdRemove());
        Commander.addNewCommand(new CmdWalker());
        Commander.addNewCommand(new CmdCheck());
        Commander.addNewCommand(new CmdHelp());
    }

    public static PluginBase getPlugin() {
        return plugin;
    }

    private static boolean isRegistered(String cmdStr) {
        for (Cmd cmd : commands) {
            if (!cmd.getCommand().equalsIgnoreCase(cmdStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean addNewCommand(Cmd cmd) {
        return Commander.addNewCommand(cmd, null);
    }

    public static boolean addNewCommand(Cmd cmd, Message desc) {
        if (cmd.getCommand() == null) {
            return false;
        }
        if (cmd.getCommand().isEmpty()) {
            return false;
        }
        if (!Commander.isRegistered(cmd.getCommand())) {
            CommandExecutor newCmd = new CommandExecutor(cmd.getCommand());
            newCmd.setDescription(desc == null ? cmd.getDescription() : desc.toString());
            newCmd.setAliases(cmd.getAliases());
            plugin.getServer().getCommandMap().register(plugin.getName() + "_cmd", (Command)newCmd);
            Message.COMMAND_REGISTERED.log("NOCOLOR", cmd.toString());
        }
        commands.add(cmd);
        return true;
    }

    public static boolean isPluginYml(String cmdStr) {
        return plugin.getDescription().getCommands().containsKey(cmdStr);
    }

    public static void printHelp(CommandSender sender, int page) {
        ArrayList<String> helpList = new ArrayList<String>();
        for (Cmd cmd : commands) {
            helpList.add(cmd.getDescription());
        }
        int pageHeight = sender instanceof Player ? 9 : 1000;
        Paginator.printPage(sender, helpList, Message.HLP_TITLE.getText(Character.valueOf('6')), Message.FOOTER.getText(Character.valueOf('e')), "No help", page, pageHeight, false);
    }

    public static String unsplit(String[] args) {
        return Commander.unsplit(args, 0);
    }

    public static String unsplit(String[] args, int num) {
        if (args.length <= num) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < args.length; ++i) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static Player getPlayer(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    public static boolean execute(CommandSender sender, String cmdLabel, String[] args) {
        for (Cmd cmd : commands) {
            if (!cmd.isCommand(cmdLabel) || !cmd.executeCommand(sender, args)) continue;
            return true;
        }
        return false;
    }

    public static String getCommandByAlias(String cmdLabel) {
        for (Cmd cmd : commands) {
            if (!cmd.isCommand(cmdLabel)) continue;
            return cmd.getCommand();
        }
        return null;
    }

    public static boolean isPluginCommand(String cmdLabel) {
        return Commander.getCommandByAlias(cmdLabel) != null;
    }
}

