/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders;

import cn.nukkit.level.Location;

public class Border {
    String world;
    int minX;
    int minZ;
    int maxX;
    int maxZ;

    public Border(Location loc1, Location loc2) {
        this(loc1.getLevel().getName(), loc1.getFloorX(), loc1.getFloorZ(), loc2.getFloorX(), loc2.getFloorZ());
    }

    public Border(String world, int x1, int z1, int x2, int z2) {
        this.world = world;
        this.minX = Math.min(x1, x2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxZ = Math.max(z1, z2);
    }

    public boolean isLocInBorder(Location loc) {
        if (!this.world.equalsIgnoreCase(loc.getLevel().getName())) {
            return false;
        }
        if (loc.getFloorX() < this.minX) {
            return false;
        }
        if (loc.getFloorX() > this.maxX) {
            return false;
        }
        if (loc.getFloorZ() < this.minZ) {
            return false;
        }
        return loc.getFloorZ() <= this.maxZ;
    }

    public String toString() {
        return this.world + ", " + this.minX + "," + this.minZ + ", " + this.maxX + "," + this.maxZ;
    }

    public String toPrintString() {
        return "[" + this.world + "] " + this.minX + "," + this.minZ + ", " + this.maxX + "," + this.maxZ;
    }
}

