/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders.commands;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import ru.nukkit.borders.Border;
import ru.nukkit.borders.Borders;
import ru.nukkit.borders.commands.Cmd;
import ru.nukkit.borders.commands.CmdDefine;
import ru.nukkit.borders.util.Message;
import ru.nukkit.borders.util.Selector;

@CmdDefine(command="border", alias="brd", subCommands={"add", "\\S+"}, permission="border.config", description=Message.CMD_BRD_ADD)
public class CmdAddBorder
extends Cmd {
    public boolean execute(CommandSender sender, Player player, String[] args) {
        Border b = Selector.getBorder(player);
        if (b == null) {
            return Message.ADD_FAIL_NEED_SEL.print((CommandSender)player, new Object[0]);
        }
        String name = args[1];
        if (Borders.exist(name)) {
            return Message.ADD_FAIL_EXIST.print(sender, Character.valueOf('c'), Character.valueOf('4'), name);
        }
        if (!name.matches("^[A-Za-z0-9_,'\\-\\+/]{1,}$")) {
            return Message.INVALID_NAME.print(sender, "a-z, 0-9, -, _");
        }
        Borders.add(name, b);
        return Message.ADD_OK.print(sender, name);
    }
}

