/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders.util;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.math.Vector3;
import ru.nukkit.borders.Borders;
import ru.nukkit.borders.util.Message;
import ru.nukkit.borders.util.PushBack;
import ru.nukkit.borders.util.Selector;
import ru.nukkit.borders.util.Walker;

public class BorderListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (Walker.isWalker(event.getPlayer())) {
            return;
        }
        if (event.getFrom().getFloorX() == event.getTo().getFloorX() && event.getFrom().getFloorY() == event.getTo().getFloorY() && event.getFrom().getFloorZ() == event.getTo().getFloorZ()) {
            return;
        }
        if (Borders.allowedLocation(event.getPlayer(), event.getTo())) {
            return;
        }
        Location back = PushBack.getLocation(event.getPlayer());
        if (back == null) {
            back = event.getFrom();
        }
        Message.BRD_FORBID_MOVE.print((CommandSender)event.getPlayer(), Character.valueOf('c'));
        event.setCancelled();
        if (!Borders.allowedLocation(event.getPlayer(), back)) {
            Message.BRD_TP_SPAWN.print((CommandSender)event.getPlayer(), Character.valueOf('c'));
            back = Location.fromObject((Vector3)event.getPlayer().getLevel().getSpawnLocation(), (Level)event.getPlayer().getLevel());
        }
        this.teleportPlayer(event.getPlayer(), back);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onBreak(BlockBreakEvent event) {
        if (Walker.isWalker(event.getPlayer())) {
            return;
        }
        Location blockLoc = new Location(event.getBlock().getX(), event.getBlock().getY(), event.getBlock().getZ(), 0.0, 0.0, event.getBlock().getLevel());
        if (Borders.allowedLocation(event.getPlayer(), blockLoc)) {
            return;
        }
        Message.BRD_FORBID_BREAK.print((CommandSender)event.getPlayer(), Character.valueOf('c'));
        event.setCancelled();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlace(BlockPlaceEvent event) {
        if (Walker.isWalker(event.getPlayer())) {
            return;
        }
        Location blockLoc = new Location(event.getBlock().getX(), event.getBlock().getY(), event.getBlock().getZ(), 0.0, 0.0, event.getBlock().getLevel());
        if (Borders.allowedLocation(event.getPlayer(), blockLoc)) {
            return;
        }
        Message.BRD_FORBID_BUILD.print((CommandSender)event.getPlayer(), Character.valueOf('c'));
        event.setCancelled();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void playerJoin(PlayerJoinEvent event) {
        PushBack.clearLoc(event.getPlayer());
        Selector.clear(event.getPlayer());
    }

    private void teleportPlayer(final Player player, final Location loc) {
        Server.getInstance().getScheduler().scheduleDelayedTask(new Runnable(){

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                player.teleport((Vector3)loc);
            }
        }, 1);
    }
}

