/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.borders.util;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.level.Location;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.TextFormat;
import java.io.File;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Message {
    LNG_LOAD_FAIL("Failed to load languages from file. Default message used"),
    LNG_SAVE_FAIL("Failed to save lang file"),
    LNG_PRINT_FAIL("Failed to print message %1%. Sender object is null."),
    LNG_CONFIG("[MESSAGES] Messages: %1% Language: %2% Debug mode: %3%"),
    CMD_BRD("Border command (type /border help)"),
    P1_SELECTED("Point #1 selected: %1%"),
    P2_SELECTED("Point #2 selected: %1%"),
    COMMAND_REGISTERED("Command registered: %1%"),
    CMD_BRD_ADD("/border add <Id> - save selection as new border"),
    CMD_BRD_SEL("/border p1 (/border p2) - select point in your location"),
    CMD_BRD_SEL2("/border p1 x z (/border p2 x z) - select x,z point  "),
    CMD_BRD_LIST("/border list [page] - show list of borders"),
    CMD_BRD_REMOVE("/border remove <Id> - remove border"),
    CMD_BRD_CHECK("/border check - determine border regions in which you're inside"),
    CMD_BRD_WALK("/border walk - toggle border walker mode (allows to walk outside the borders)"),
    CMD_BRD_RELOAD("/border reload - reload configuration"),
    CMD_HLP("/border help - show help page"),
    ADD_FAIL_NEED_SEL("Failed to add border %1%! You need to select two points!"),
    INVALID_NAME("Border name is inavlid. Allowed characters: %1%"),
    ADD_OK("Border %1% added!"),
    BRD_LST_TITLE("Border list"),
    FOOTER("Page [%1% / %1%]"),
    BRD_LST_EMPTY("No borders defined!"),
    BRD_UNKNOWN("Unknown border: %1%"),
    BRD_REMOVED("Border %1% removed!"),
    HLP_TITLE("Help"),
    BRD_TP_SPAWN("You were teleported to spawn location!"),
    BRD_FORBID_MOVE("You can't move outside of the border!"),
    BRD_FORBID_BREAK("You can't break blocks outside of the border!"),
    BRD_FORBID_BUILD("You can't build blocks outside of the border!"),
    WALKER_ON("Walker mode enabled! You can walk anywhere you want!"),
    WALKER_OFF("Walker mode disabled!"),
    ADD_FAIL_EXIST("Failed to add new border. Id %1% already used for another border!"),
    CHK_NOT_FOUND("Border regions not found around you"),
    CHK_FOUND("List of border regions around you"),
    BRD_RELOADED("Borders configuration reloaded. Loaded %1% borders");

    private static boolean debugMode;
    private static String language;
    private static char c1;
    private static char c2;
    private static PluginBase plugin;
    private String message;

    public static void BC(Object ... s) {
        if (!debugMode) {
            return;
        }
        if (s.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder("&3[").append(plugin.getDescription().getName()).append("]&f ");
        for (Object str : s) {
            sb.append(str.toString()).append(" ");
        }
        plugin.getServer().broadcastMessage(TextFormat.colorize((String)sb.toString().trim()));
    }

    public boolean log(Object ... s) {
        plugin.getLogger().info(this.getText(s));
        return true;
    }

    public boolean debug(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)this.getText(s)));
        }
        return true;
    }

    public boolean tip(int seconds, CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        final Player player = sender instanceof Player ? (Player)sender : null;
        final String message = this.getText(s);
        if (player == null) {
            sender.sendMessage(message);
        } else {
            for (int i = 0; i < seconds; ++i) {
                Server.getInstance().getScheduler().scheduleDelayedTask(new Runnable(){

                    public void run() {
                        if (player.isOnline()) {
                            player.sendTip(message);
                        }
                    }
                }, 20 * i);
            }
        }
        return true;
    }

    public boolean tip(CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        String message = this.getText(s);
        if (player == null) {
            sender.sendMessage(message);
        } else {
            player.sendTip(message);
        }
        return true;
    }

    public boolean print(CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        sender.sendMessage(this.getText(s));
        return true;
    }

    public boolean broadcast(String permission, Object ... s) {
        for (Player player : plugin.getServer().getOnlinePlayers().values()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            this.print((CommandSender)player, s);
        }
        return true;
    }

    public String getText(Object ... keys) {
        if (keys.length == 0) {
            return TextFormat.colorize((String)("&" + c1 + this.message));
        }
        String str = this.message;
        boolean noColors = false;
        boolean skipDefaultColors = false;
        boolean fullFloat = false;
        int count = 1;
        char[] colors = new char[]{c1, c2};
        int c = 0;
        DecimalFormat fmt = new DecimalFormat("####0.##");
        for (int i = 0; i < keys.length; ++i) {
            String s = keys[i].toString();
            if (c < 2 && keys[i] instanceof Character) {
                colors[c] = ((Character)keys[i]).charValue();
                ++c;
                continue;
            }
            if (s.equals("SKIPCOLOR")) {
                skipDefaultColors = true;
                continue;
            }
            if (s.equals("NOCOLORS") || s.equals("NOCOLOR")) {
                noColors = true;
                continue;
            }
            if (s.equals("FULLFLOAT")) {
                fullFloat = true;
                continue;
            }
            if (keys[i] instanceof Location) {
                Location loc = (Location)keys[i];
                s = fullFloat ? loc.getLevel().getName() + "[" + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + "]" : loc.getLevel().getName() + "[" + fmt.format(loc.getX()) + ", " + fmt.format(loc.getY()) + ", " + fmt.format(loc.getZ()) + "]";
            } else if ((keys[i] instanceof Double || keys[i] instanceof Float) && !fullFloat) {
                s = fmt.format((Double)keys[i]);
            }
            String from = "%" + count + "%";
            String to = skipDefaultColors ? s : "&" + colors[1] + s + "&" + colors[0];
            str = str.replace(from, to);
            ++count;
        }
        str = TextFormat.colorize((String)("&" + colors[0] + str));
        if (noColors) {
            str = TextFormat.clean((String)str);
        }
        return str;
    }

    private void initMessage(String message) {
        this.message = message;
    }

    private Message(String msg) {
        this.message = msg;
    }

    public String toString() {
        return this.getText("NOCOLOR");
    }

    public static void init(PluginBase plg) {
        plugin = plg;
        plugin.getDataFolder().mkdirs();
        File f = new File(plugin.getDataFolder() + File.separator + "config.yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        language = (String)plg.getConfig().getNested("general.language", (Object)"english");
        plg.getConfig().setNested("general.language", (Object)language);
        debugMode = (Boolean)plg.getConfig().getNested("general.debug-mode", (Object)false);
        plg.getConfig().setNested("general.debug-mode", (Object)debugMode);
        plg.saveConfig();
        Message.initMessages();
        Message.saveMessages();
        LNG_CONFIG.debug(Message.values().length, language, true, debugMode);
    }

    public static void setDebugMode(boolean debug) {
        debugMode = debug;
    }

    private static boolean copyLanguage() {
        return plugin.saveResource("lang/" + language + ".lng", language + ".lng", false);
    }

    private static void initMessages() {
        Message.copyLanguage();
        Config lng = null;
        try {
            File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
            if (!f.exists()) {
                f.createNewFile();
            }
            lng = new Config(f, 2);
        }
        catch (Exception e) {
            LNG_LOAD_FAIL.log(new Object[0]);
            if (debugMode) {
                e.printStackTrace();
            }
            return;
        }
        for (Message key : Message.values()) {
            key.initMessage((String)lng.getNested(key.name().toLowerCase(), (Object)key.message));
        }
    }

    private static void saveMessages() {
        block3: {
            File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
            Config lng = new Config(f, 2);
            for (Message key : Message.values()) {
                lng.setNested(key.name().toLowerCase(), (Object)key.message);
            }
            try {
                lng.save();
            }
            catch (Exception e) {
                LNG_SAVE_FAIL.log(new Object[0]);
                if (!debugMode) break block3;
                e.printStackTrace();
            }
        }
    }

    public static boolean debugMessage(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)Message.join(s)));
        }
        return true;
    }

    public static String join(Object ... s) {
        StringBuilder sb = new StringBuilder();
        for (Object o : s) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    static {
        debugMode = false;
        language = "english";
        c1 = (char)97;
        c2 = (char)50;
        plugin = null;
    }
}

