/*
 * Decompiled with CFR 0.152.
 */
package net.skidcode.gh.chatbridge;

import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import java.io.File;
import java.util.LinkedHashMap;
import net.skidcode.gh.chatbridge.bot.DiscordBot;
import net.skidcode.gh.chatbridge.listeners.PlayerChatEventListener;
import net.skidcode.gh.chatbridge.listeners.PlayerJoinEventListener;
import net.skidcode.gh.chatbridge.listeners.PlayerQuitEventListener;
import net.skidcode.gh.chatbridge.listeners.ServerCommandEventListener;

public class DiscordChatbridge
extends PluginBase {
    public static ConfigSection stringsConfig;
    public static ConfigSection discordBotConfig;
    public static boolean DISCORD2GAME;
    public static volatile DiscordChatbridge INSTANCE;

    static {
        DISCORD2GAME = true;
        stringsConfig = new ConfigSection();
        stringsConfig.put((Object)"joined-game", (Object)"%PLAYER% joined the game");
        stringsConfig.put((Object)"left-game", (Object)"%PLAYER% left the game");
        stringsConfig.put((Object)"death-message-mob", (Object)"%PLAYER% was killed by %CAUSE%");
        stringsConfig.put((Object)"chat-format", (Object)"<%PLAYER%> %MESSAGE%");
        stringsConfig.put((Object)"console-broadcast-format", (Object)"[%CONSOLE%] %MESSAGE%");
        stringsConfig.put((Object)"plugin-loaded", (Object)"Starting chatbridge...");
        stringsConfig.put((Object)"plugin-unloaded", (Object)"Stopping chatbridge...");
        stringsConfig.put((Object)"discord-to-game", (Object)"[Discord] %USERNAME%: %MESSAGE%");
        discordBotConfig = new ConfigSection();
        discordBotConfig.put((Object)"token", (Object)"");
        discordBotConfig.put((Object)"channelID", (Object)0);
        discordBotConfig.put((Object)"guildID", (Object)0);
        discordBotConfig.put((Object)"discord-to-game", (Object)true);
        discordBotConfig.put((Object)"bot-default-prefix", (Object)"!");
        discordBotConfig.put((Object)"enable-online-command", (Object)true);
    }

    public DiscordChatbridge() {
        INSTANCE = this;
    }

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        File strings = new File(this.getDataFolder(), "strings.yml");
        Config conf = new Config(strings, 2, (LinkedHashMap)stringsConfig);
        stringsConfig = new ConfigSection((LinkedHashMap)conf.getAll());
        File config = new File(this.getDataFolder(), "config.yml");
        conf = new Config(config, 2, (LinkedHashMap)discordBotConfig);
        discordBotConfig = new ConfigSection((LinkedHashMap)conf.getAll());
        DISCORD2GAME = discordBotConfig.getBoolean("discord-to-game");
        DiscordBot.ENABLE_ONLINE_COMMAND = discordBotConfig.getBoolean("enable-online-command");
        DiscordBot.BOT_PREFIX = discordBotConfig.getString("bot-default-prefix");
        DiscordBot.BOT_PREFIX_SIZE = DiscordBot.BOT_PREFIX.length();
        DiscordBot.runBot(discordBotConfig.getString("token"), discordBotConfig.getLong("channelID"), discordBotConfig.getLong("guildID"));
        DiscordBot.scheduleMessageSent(stringsConfig.getString("plugin-loaded"));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ServerCommandEventListener(), (Plugin)this);
    }

    public void onDisable() {
        DiscordBot.scheduleMessageSent(stringsConfig.getString("plugin-unloaded"));
        try {
            DiscordBot.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

