/*
 * Decompiled with CFR 0.152.
 */
package net.skidcode.gh.chatbridge.bot;

import cn.nukkit.Player;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.skidcode.gh.chatbridge.DiscordChatbridge;

public class DiscordBot {
    private static String BOT_TOKEN;
    public static long CHANNEL_ID;
    public static long GUILD_ID;
    public static String BOT_PREFIX;
    public static boolean ENABLE_ONLINE_COMMAND;
    public static volatile JDA jdaInstance;
    public static volatile boolean READY;
    public static ArrayList<String> messages;
    public static int BOT_PREFIX_SIZE;

    static {
        READY = false;
        messages = new ArrayList();
    }

    public static void runBot(String token, long channelID, long guildID) {
        BOT_TOKEN = token;
        CHANNEL_ID = channelID;
        GUILD_ID = guildID;
        JDABuilder builder = JDABuilder.createDefault((String)BOT_TOKEN, (Collection)GatewayIntent.getIntents((int)(GatewayIntent.DEFAULT | GatewayIntent.MESSAGE_CONTENT.getRawValue())));
        jdaInstance = builder.build();
        jdaInstance.addEventListener(new Object[]{new EventListener(){

            public void onEvent(GenericEvent event) {
                if (event instanceof ReadyEvent) {
                    System.out.println("API is ready");
                    READY = true;
                    TextChannel c = jdaInstance.getGuildById(GUILD_ID).getTextChannelById(CHANNEL_ID);
                    System.out.println(c.getName());
                    for (String message : messages) {
                        c.sendMessage((CharSequence)message).queue();
                    }
                } else if (event instanceof MessageReceivedEvent) {
                    String msgNonPrefixed;
                    String msg;
                    MessageReceivedEvent mre = (MessageReceivedEvent)event;
                    if (DiscordChatbridge.DISCORD2GAME && mre.getMessage().getChannel().getIdLong() == CHANNEL_ID && mre.getMessage().getGuild().getIdLong() == GUILD_ID && !mre.getAuthor().isBot()) {
                        String username = mre.getMember().getNickname();
                        if (username == null) {
                            username = mre.getAuthor().getEffectiveName();
                        }
                        DiscordChatbridge.INSTANCE.getServer().broadcastMessage(DiscordChatbridge.stringsConfig.getString("discord-to-game").replace("%USERNAME%", username).replace("%MESSAGE%", mre.getMessage().getContentDisplay()));
                    }
                    if (ENABLE_ONLINE_COMMAND && !mre.getAuthor().isBot() && (msg = mre.getMessage().getContentDisplay().toLowerCase()).startsWith(BOT_PREFIX) && ((msgNonPrefixed = msg.substring(BOT_PREFIX_SIZE)).startsWith("online") || msgNonPrefixed.startsWith("list"))) {
                        int total = DiscordChatbridge.INSTANCE.getServer().getOnlinePlayers().size();
                        int max = DiscordChatbridge.INSTANCE.getServer().getMaxPlayers();
                        String desc = "";
                        for (Player p : DiscordChatbridge.INSTANCE.getServer().getOnlinePlayers().values()) {
                            desc = String.valueOf(desc) + "\u2022 `" + p.getName() + "`\n";
                        }
                        EmbedBuilder emb = new EmbedBuilder().setTitle("Currently online: " + total + "/" + max + " players").setDescription((CharSequence)desc.trim());
                        mre.getChannel().sendMessageEmbeds(emb.build(), new MessageEmbed[0]).queue();
                    }
                }
            }
        }});
    }

    public static void scheduleMessageSent(String message) {
        if (READY) {
            jdaInstance.getGuildById(GUILD_ID).getTextChannelById(CHANNEL_ID).sendMessage((CharSequence)message).queue();
        }
        messages.add(message);
    }

    public static void stop() throws InterruptedException {
        jdaInstance.shutdown();
        jdaInstance.awaitShutdown(Duration.ofSeconds(3L));
    }
}

