/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.easyauth;

import cn.nukkit.Player;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.Utils;
import cn.yescallop.easyauth.EventListener;
import cn.yescallop.easyauth.lang.BaseLang;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EasyAuth
extends PluginBase {
    private BaseLang lang;
    private byte[] salt;
    private File playersFolder;
    private ArrayList<Player> authedPlayers = new ArrayList();

    public void onEnable() {
        this.getDataFolder().mkdirs();
        File saltFile = new File(this.getDataFolder(), "salt.txt");
        try {
            if (!saltFile.exists()) {
                saltFile.createNewFile();
                Utils.writeFile((File)saltFile, (String)this.getRandomSalt());
            }
            String salt = Utils.readFile((File)saltFile);
            this.salt = new BASE64Decoder().decodeBuffer(salt);
        }
        catch (IOException e) {
            this.salt = new byte[0];
        }
        this.playersFolder = new File(this.getDataFolder(), "players");
        this.playersFolder.mkdirs();
        this.lang = new BaseLang(this.getServer().getLanguage().getLang());
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        for (Player player : this.getServer().getOnlinePlayers().values()) {
            if (!this.isPlayerLastUUID(player)) continue;
            this.authenticatePlayer(player);
        }
        this.getLogger().info(this.lang.translateString("easyauth.loaded"));
    }

    private String getRandomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return new BASE64Encoder().encode(salt);
    }

    public BaseLang getLanguage() {
        return this.lang;
    }

    public void authenticatePlayer(Player player) {
        this.authedPlayers.add(player);
        this.setPlayerLastUUID(player);
    }

    public void deauthenticatePlayer(Player player) {
        this.authedPlayers.remove(player);
    }

    public boolean isPlayerAuthenticated(Player player) {
        return this.authedPlayers.contains(player);
    }

    private byte[] getEncryptedPassword(String password) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(this.salt);
            digest.update(password.getBytes("UTF-8"));
        }
        catch (Exception e) {
            return new byte[0];
        }
        return digest.digest();
    }

    private String getEncryptedPasswordString(String password) {
        return new BASE64Encoder().encode(this.getEncryptedPassword(password));
    }

    public boolean checkPlayerPassword(Player player, String password) {
        byte[] realPassword;
        Config config = this.getPlayerConfig(player);
        String realPasswordStr = config.getString("password");
        if (realPasswordStr == null) {
            return false;
        }
        try {
            realPassword = new BASE64Decoder().decodeBuffer(realPasswordStr);
        }
        catch (IOException e) {
            return false;
        }
        byte[] encryptedPassword = this.getEncryptedPassword(password);
        return Arrays.equals(realPassword, encryptedPassword);
    }

    public void setPlayerPassword(Player player, String password) {
        Config config = this.getPlayerConfig(player);
        String encryptedPassword = this.getEncryptedPasswordString(password);
        config.set("password", (Object)encryptedPassword);
        config.save();
    }

    public void registerPlayer(Player player, String password) {
        this.setPlayerPassword(player, password);
        this.authenticatePlayer(player);
    }

    public void unregisterPlayer(Player player) {
        this.deauthenticatePlayer(player);
        this.getPlayerConfigFile(player).delete();
    }

    public boolean isPlayerRegistered(Player player) {
        return this.getPlayerConfigFile(player).exists();
    }

    public void setPlayerLastUUID(Player player) {
        Config config = this.getPlayerConfig(player);
        config.set("lastUUID", (Object)player.getUniqueId().toString());
        config.save();
    }

    public UUID getPlayerLastUUID(Player player) {
        if (this.isPlayerRegistered(player)) {
            Config config = this.getPlayerConfig(player);
            String uuid = config.getString("lastUUID");
            return UUID.fromString(uuid);
        }
        return null;
    }

    public boolean isPlayerLastUUID(Player player) {
        UUID uuid = this.getPlayerLastUUID(player);
        if (uuid == null) {
            return false;
        }
        return player.getUniqueId().equals(uuid);
    }

    public File getPlayerConfigFile(Player player) {
        return new File(this.playersFolder, player.getName().toLowerCase() + ".yml");
    }

    public Config getPlayerConfig(Player player) {
        return new Config(this.getPlayerConfigFile(player), 2);
    }
}

