/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.easyauth.lang;

import cn.nukkit.Server;
import cn.nukkit.event.TextContainer;
import cn.nukkit.event.TranslationContainer;
import cn.nukkit.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class BaseLang {
    public static final String FALLBACK_LANGUAGE = "eng";
    protected String langName;
    protected Map<String, String> lang = new HashMap<String, String>();
    protected Map<String, String> fallbackLang = new HashMap<String, String>();

    public BaseLang(String lang) {
        this(lang, null);
    }

    public BaseLang(String lang, String path) {
        this(lang, path, FALLBACK_LANGUAGE);
    }

    public BaseLang(String lang, String path, String fallback) {
        this.langName = lang.toLowerCase();
        if (path == null) {
            path = "lang/";
            try {
                this.lang = this.loadLang(this.getClass().getClassLoader().getResourceAsStream(path + this.langName + ".ini"));
            }
            catch (NullPointerException e) {
                this.lang = new HashMap<String, String>();
            }
            this.fallbackLang = this.loadLang(this.getClass().getClassLoader().getResourceAsStream(path + fallback + ".ini"));
        } else {
            try {
                this.lang = this.loadLang(path + this.langName + ".ini");
            }
            catch (NullPointerException e) {
                this.lang = new HashMap<String, String>();
            }
            this.fallbackLang = this.loadLang(path + fallback + ".ini");
        }
    }

    public String getName() {
        return this.get("language.name");
    }

    public String getLang() {
        return this.langName;
    }

    protected Map<String, String> loadLang(String path) {
        try {
            String content = Utils.readFile((String)path);
            HashMap<String, String> d = new HashMap<String, String>();
            for (String line : content.split("\n")) {
                String[] t;
                if ((line = line.trim()).equals("") || line.charAt(0) == '#' || (t = line.split("=")).length < 2) continue;
                String key = t[0];
                String value = "";
                for (int i = 1; i < t.length - 1; ++i) {
                    value = value + t[i] + "=";
                }
                if ((value = value + t[t.length - 1]).equals("")) continue;
                d.put(key, value);
            }
            return d;
        }
        catch (IOException e) {
            Server.getInstance().getLogger().logException((Exception)e);
            return null;
        }
    }

    protected Map<String, String> loadLang(InputStream stream) {
        try {
            String content = Utils.readFile((InputStream)stream);
            HashMap<String, String> d = new HashMap<String, String>();
            for (String line : content.split("\n")) {
                String[] t;
                if ((line = line.trim()).equals("") || line.charAt(0) == '#' || (t = line.split("=")).length < 2) continue;
                String key = t[0];
                String value = "";
                for (int i = 1; i < t.length - 1; ++i) {
                    value = value + t[i] + "=";
                }
                if ((value = value + t[t.length - 1]).equals("")) continue;
                d.put(key, value);
            }
            return d;
        }
        catch (IOException e) {
            Server.getInstance().getLogger().logException((Exception)e);
            return null;
        }
    }

    public String translateString(String str) {
        return this.translateString(str, new String[0], null);
    }

    public String translateString(String str, String param) {
        return this.translateString(str, new String[]{param});
    }

    public String translateString(String str, String[] params) {
        return this.translateString(str, params, null);
    }

    public String translateString(String str, String param, String onlyPrefix) {
        return this.translateString(str, new String[]{param}, onlyPrefix);
    }

    public String translateString(String str, String[] params, String onlyPrefix) {
        String baseText = this.get(str);
        baseText = this.parseTranslation(baseText != null && (onlyPrefix == null || str.indexOf(onlyPrefix) == 0) ? baseText : str, onlyPrefix);
        for (int i = 0; i < params.length; ++i) {
            baseText = baseText.replace("{%" + i + "}", this.parseTranslation(params[i]));
        }
        return baseText;
    }

    public String translate(TextContainer c) {
        String baseText = this.parseTranslation(c.getText());
        if (c instanceof TranslationContainer) {
            baseText = this.internalGet(c.getText());
            baseText = this.parseTranslation(baseText != null ? baseText : c.getText());
            for (int i = 0; i < ((TranslationContainer)c).getParameters().length; ++i) {
                baseText = baseText.replace("{%" + i + "}", this.parseTranslation(((TranslationContainer)c).getParameters()[i]));
            }
        }
        return baseText;
    }

    public String internalGet(String id) {
        if (this.lang.containsKey(id)) {
            return this.lang.get(id);
        }
        if (this.fallbackLang.containsKey(id)) {
            return this.fallbackLang.get(id);
        }
        return null;
    }

    public String get(String id) {
        if (this.lang.containsKey(id)) {
            return this.lang.get(id);
        }
        if (this.fallbackLang.containsKey(id)) {
            return this.fallbackLang.get(id);
        }
        return id;
    }

    protected String parseTranslation(String text) {
        return this.parseTranslation(text, null);
    }

    protected String parseTranslation(String text, String onlyPrefix) {
        String newString = "";
        String replaceString = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (replaceString != null) {
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.') {
                    replaceString = replaceString + String.valueOf(c);
                    continue;
                }
                String t = this.internalGet(replaceString.substring(1));
                newString = t != null && (onlyPrefix == null || replaceString.indexOf(onlyPrefix) == 1) ? newString + t : newString + replaceString;
                replaceString = null;
                if (c == '%') {
                    replaceString = String.valueOf(c);
                    continue;
                }
                newString = newString + String.valueOf(c);
                continue;
            }
            if (c == '%') {
                replaceString = String.valueOf(c);
                continue;
            }
            newString = newString + String.valueOf(c);
        }
        if (replaceString != null) {
            String t = this.internalGet(replaceString.substring(1));
            newString = t != null && (onlyPrefix == null || replaceString.indexOf(onlyPrefix) == 1) ? newString + t : newString + replaceString;
        }
        return newString;
    }
}

