/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.easyauth;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.inventory.InventoryPickupItemEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerDropItemEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerItemConsumeEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.inventory.InventoryHolder;
import cn.yescallop.easyauth.EasyAuth;
import cn.yescallop.easyauth.lang.BaseLang;
import java.util.HashMap;

public class EventListener
implements Listener {
    EasyAuth plugin;
    BaseLang lang;
    HashMap<Player, String> confirmWaiting = new HashMap();

    public EventListener(EasyAuth plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguage();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isPlayerLastUUID(player)) {
            this.plugin.authenticatePlayer(player);
            player.sendMessage(this.lang.translateString("login.auto"));
        } else {
            player.sendMessage(this.plugin.isPlayerRegistered(player) ? this.lang.translateString("login.input") : this.lang.translateString("register.input"));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (!this.plugin.isPlayerAuthenticated(player)) {
            event.setCancelled();
            if (!this.plugin.isPlayerRegistered(player)) {
                if (!this.confirmWaiting.containsKey(player)) {
                    player.sendMessage(this.lang.translateString("register.confirm", message));
                    this.confirmWaiting.put(player, message);
                } else if (!message.equals("back")) {
                    if (message.equals(this.confirmWaiting.get(player))) {
                        this.plugin.registerPlayer(player, message);
                        player.sendMessage(this.lang.translateString("register.success"));
                        this.confirmWaiting.remove(player);
                    } else {
                        player.sendMessage(this.lang.translateString("register.notmatching"));
                    }
                } else {
                    player.sendMessage(this.lang.translateString("register.reinput"));
                    this.confirmWaiting.remove(player);
                }
            } else if (this.plugin.checkPlayerPassword(player, message)) {
                this.plugin.authenticatePlayer(player);
                player.sendMessage(this.lang.translateString("login.success"));
            } else {
                player.kick(this.lang.translateString("login.fail"));
                Server.getInstance().getNetwork().blockAddress(player.getAddress(), 30);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Player && !this.plugin.isPlayerAuthenticated((Player)holder)) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer()) && event.getMessage().startsWith("/")) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.deauthenticatePlayer(player);
        this.confirmWaiting.remove(player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player && !this.plugin.isPlayerAuthenticated((Player)entity)) {
            event.setCancelled();
        }
    }
}

