/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.command;

import cc.leet.economy.Economy;
import cc.leet.economy.util.MoneyHandler;
import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;

public class BalanceCommand
extends Command {
    private Economy plugin;
    private MoneyHandler api;

    public BalanceCommand(Economy plugin) {
        super("balance", "Checks the balance of a player", "/balance [optional player]", new String[]{"bal", "money"});
        this.plugin = plugin;
        this.api = plugin.getAPI();
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        boolean plural;
        boolean own;
        if (sender.isPlayer() && !sender.hasPermission("economy.command.balance")) {
            sender.sendMessage(this.plugin.getMessages().noPermission());
            return true;
        }
        boolean bl = own = args.length < 1;
        if (!own && args[0].equalsIgnoreCase(sender.getName())) {
            own = true;
        }
        if (!this.api.exists(sender.getName())) {
            this.api.createPlayer(sender.getName());
        }
        if (!own && !this.api.exists(args[0])) {
            Player player = this.plugin.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage(this.plugin.getMessages().playerNotExists());
                return true;
            }
            this.api.createPlayer(args[0]);
        }
        double balance = this.api.getBalance(own ? sender.getName() : args[0]);
        boolean bl2 = plural = balance > 1.0;
        sender.sendMessage(own ? this.plugin.getMessages().balanceOwn(balance, plural ? this.api.getPlural() : this.api.getSingular()) : this.plugin.getMessages().balanceOther(args[0], balance, plural ? this.api.getPlural() : this.api.getSingular()));
        return true;
    }
}

