/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.command;

import cc.leet.economy.Economy;
import cc.leet.economy.event.EconomyGiveMoneyEvent;
import cc.leet.economy.util.MoneyHandler;
import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Event;

public class GiveMoneyCommand
extends Command {
    private Economy plugin;
    private MoneyHandler api;

    public GiveMoneyCommand(Economy plugin) {
        super("givemoney", "Gives a specified amount of money to a player", "/givemoney [player] [amount]");
        this.plugin = plugin;
        this.api = plugin.getAPI();
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        double amount;
        if (!sender.hasPermission("economy.command.givemoney")) {
            sender.sendMessage(this.plugin.getMessages().noPermission());
            return true;
        }
        if (args.length < 2) {
            if (args.length < 2) {
                sender.sendMessage(this.plugin.getMessages().amountMissing());
            }
            if (args.length < 1) {
                sender.sendMessage(this.plugin.getMessages().playerMissing());
            }
            return true;
        }
        String target = args[0];
        if (!this.api.exists(target)) {
            Player player = this.plugin.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage(this.plugin.getMessages().playerNotExists());
                return true;
            }
            this.api.createPlayer(target);
        }
        try {
            amount = Double.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        if (amount <= 0.0) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        this.api.alterBalance(target, amount);
        sender.sendMessage(this.plugin.getMessages().balanceGiven(amount, amount > 1.0 ? this.api.getPlural() : this.api.getSingular(), target));
        this.plugin.getServer().getPluginManager().callEvent((Event)new EconomyGiveMoneyEvent(this.plugin, sender.getName(), target, amount));
        return true;
    }
}

