/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.util;

import cc.leet.economy.Economy;
import cn.nukkit.utils.TextFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class Messages {
    private static HashMap<String, String> colors;
    private String no_permission;
    private String balance_own;
    private String balance_other;
    private String balance_too_low;
    private String balance_sent;
    private String balance_received;
    private String balance_reduced;
    private String balance_given;
    private String balance_set;
    private String balance_changed;
    private String balance_took;
    private String balance_rank;
    private String balance_top;
    private String amount_missing;
    private String amount_invalid;
    private String amount_too_high;
    private String player_missing;
    private String player_not_exists;

    public Messages(Economy plugin) {
        Messages.findColors();
        this.no_permission = (String)plugin.getConfig().getNested("messages.no-permission", (Object)"%red%You don't have permission to do that.");
        this.balance_own = (String)plugin.getConfig().getNested("messages.balance.own", (Object)"%yellow%Your balance is %green%{0} %yellow%{1}");
        this.balance_other = (String)plugin.getConfig().getNested("messages.balance.other", (Object)"%yellow%{0}s balance is %green%{1} %yellow%{2}");
        this.balance_too_low = (String)plugin.getConfig().getNested("messages.balance.too-low", (Object)"%red%You do not have enough money.");
        this.balance_sent = (String)plugin.getConfig().getNested("messages.balance.sent", (Object)"%yellow%You sent %green%{0} %yellow%{1} to %green%{2}");
        this.balance_received = (String)plugin.getConfig().getNested("messages.balance.received", (Object)"%green%{0} %yellow%sent you %green%{1} %yellow%{2}");
        this.balance_reduced = (String)plugin.getConfig().getNested("messages.balance.reduced", (Object)"%yellow%{0} took %green%{1} %yellow%{2} from you");
        this.balance_took = (String)plugin.getConfig().getNested("messages.balance.took", (Object)"%yellow%You took %green%{0} %yellow%{1} from %green%{2}");
        this.balance_given = (String)plugin.getConfig().getNested("messages.balance.given", (Object)"%green%{0} %yellow%{1} was given to %green%{2}");
        this.balance_set = (String)plugin.getConfig().getNested("messages.balance.set", (Object)"%green%{0}%yellow%'s balance has been set to %green%{1} %yellow%{2}");
        this.balance_changed = (String)plugin.getConfig().getNested("messages.balance.changed", (Object)"%yellow%Your balance has been set to %green%{0} %yellow%{1} by %green%{2}");
        this.balance_rank = (String)plugin.getConfig().getNested("messages.balance.rank", (Object)"%yellow%Your rank is %green%{0}");
        this.balance_top = (String)plugin.getConfig().getNested("messages.balance.top", (Object)"%yellow%{0}. {1} - %green%{2} %yellow%{3}");
        this.amount_missing = (String)plugin.getConfig().getNested("messages.amount-missing", (Object)"%red%You need to specify an amount.");
        this.amount_invalid = (String)plugin.getConfig().getNested("messages.amount-invalid", (Object)"%red%The specified amount is invalid!");
        this.amount_too_high = (String)plugin.getConfig().getNested("messages.amount-too-high", (Object)"%yellow%The amount was higher than the target's balance.");
        this.player_missing = (String)plugin.getConfig().getNested("messages.player.missing", (Object)"%red%You need to specify a player.");
        this.player_not_exists = (String)plugin.getConfig().getNested("messages.player.not-exists", (Object)"%red%The specified player does not exist.");
    }

    public static void findColors() {
        Field[] declaredFields;
        colors = new HashMap();
        for (Field field : declaredFields = TextFormat.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (field.getName().equalsIgnoreCase("ESCAPE")) continue;
                colors.put(field.getName(), (String)TextFormat.class.getDeclaredField(field.getName()).get(String.class));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private String parse(String message, Object ... params) {
        return MessageFormat.format(this.parseColors(message), params);
    }

    private String parseColors(String msg) {
        String message = msg;
        for (Map.Entry<String, String> color : colors.entrySet()) {
            String colorKey = "%" + color.getKey().toLowerCase() + "%";
            if (!message.contains(colorKey)) continue;
            message = message.replaceAll(colorKey, color.getValue());
        }
        return message;
    }

    public String noPermission() {
        return this.parse(this.no_permission, new Object[0]);
    }

    public String balanceOwn(double balance, String currency) {
        return this.parse(this.balance_own, balance, currency);
    }

    public String balanceOther(String player, double balance, String currency) {
        return this.parse(this.balance_other, player, balance, currency);
    }

    public String balanceTooLow() {
        return this.parse(this.balance_too_low, new Object[0]);
    }

    public String balanceSent(double amount, String currency, String player) {
        return this.parse(this.balance_sent, amount, currency, player);
    }

    public String balanceReceived(String sender, double amount, String currency) {
        return this.parse(this.balance_received, sender, amount, currency);
    }

    public String balanceReduced(String player, double amount, String currency) {
        return this.parse(this.balance_reduced, player, amount, currency);
    }

    public String balanceTook(double amount, String currency, String player) {
        return this.parse(this.balance_took, amount, currency, player);
    }

    public String balanceGiven(double amount, String currency, String receiver) {
        return this.parse(this.balance_given, amount, currency, receiver);
    }

    public String balanceSet(String player, double balance, String currency) {
        return this.parse(this.balance_set, player, balance, currency);
    }

    public String balanceChanged(double balance, String currency, String sender) {
        return this.parse(this.balance_changed, balance, currency, sender);
    }

    public String balanceRank(int rank) {
        return this.parse(this.balance_rank, rank);
    }

    public String balanceTop(int rank, String player, double balance, String currency) {
        return this.parse(this.balance_top, rank, player, balance, currency);
    }

    public String amountMissing() {
        return this.parse(this.amount_missing, new Object[0]);
    }

    public String amountInvalid() {
        return this.parse(this.amount_invalid, new Object[0]);
    }

    public String amountTooHigh() {
        return this.parse(this.amount_too_high, new Object[0]);
    }

    public String playerMissing() {
        return this.parse(this.player_missing, new Object[0]);
    }

    public String playerNotExists() {
        return this.parse(this.player_not_exists, new Object[0]);
    }
}

