/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.util;

import cc.leet.economy.Economy;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MoneyHandler {
    private Economy plugin;
    private Config money;
    private File moneyFile;
    private String cSymbol;
    private String cSingle;
    private String cPlural;
    private double startBalance;
    private HashMap<String, Double> players = new HashMap();

    public MoneyHandler(Economy plugin) {
        this.moneyFile = new File(plugin.getDataFolder(), "money.yml");
        if (!this.moneyFile.exists()) {
            plugin.saveResource("money.yml");
        }
        this.money = new Config(this.moneyFile, 2);
        this.cSymbol = (String)plugin.getConfig().getNested("currency.symbol", (Object)"$");
        this.cSingle = (String)plugin.getConfig().getNested("currency.single", (Object)"Dollar");
        this.cPlural = (String)plugin.getConfig().getNested("currency.plural", (Object)"Dollars");
        this.startBalance = (Double)plugin.getConfig().getNested("currency.start-balance", (Object)100.0);
        this.load();
    }

    public double getBalance(String player) {
        if (!this.players.containsKey(player = player.toLowerCase())) {
            this.createPlayer(player);
        }
        return this.players.get(player);
    }

    public HashMap<String, Double> getBalanceAll() {
        return this.players;
    }

    public String getSymbol() {
        return this.cSymbol;
    }

    public String getSingular() {
        return this.cSingle;
    }

    public String getPlural() {
        return this.cPlural;
    }

    public boolean setBalance(String player, double balance) {
        if (!this.exists(player = player.toLowerCase())) {
            if (this.plugin.getServer().getPlayer(player) == null) {
                return false;
            }
            this.createPlayer(player, balance);
        }
        this.money.setNested("balance." + player, (Object)balance);
        this.money.save();
        this.players.put(player, balance);
        return this.players.get(player) == balance;
    }

    public boolean alterBalance(String player, double balance) {
        player = player.toLowerCase();
        if (balance == 0.0) {
            return false;
        }
        if (!this.exists(player)) {
            this.createPlayer(player);
            if (!this.exists(player)) {
                return false;
            }
        }
        double b = this.getBalance(player);
        if (balance < 0.0 && b - balance < 0.0) {
            return false;
        }
        this.players.put(player, balance > 0.0 ? b + balance : b - Math.abs(balance));
        return this.players.get(player) != b;
    }

    public void createPlayer(String player) {
        this.createPlayer(player, this.startBalance);
    }

    public void createPlayer(String player, double balance) {
        player = player.toLowerCase();
        if (balance < 0.0) {
            this.plugin.getLogger().emergency("Attempted to create player " + player + " with balance " + balance + " which is a negative value.");
            return;
        }
        this.money.setNested("balance." + player, (Object)balance);
        this.money.save();
        this.players.put(player, balance);
    }

    public void save() {
        this.money.set("balance", this.players);
        this.money.save();
    }

    public boolean exists(String player) {
        if (this.players.containsKey(player = player.toLowerCase())) {
            return true;
        }
        if (this.money.getNested("balance." + player) != null) {
            this.players.put(player, (double)((Double)this.money.getNested("balance." + player)));
            return true;
        }
        return false;
    }

    public void load() {
        LinkedHashMap all = (LinkedHashMap)this.money.get("balance");
        Iterator iterator = all.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.players.put(entry.getKey().toString(), (double)((Double)entry.getValue()));
        }
    }

    public LinkedHashMap getTop(int amount) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        int i = 0;
        for (Map.Entry<String, Double> entry : this.sortByValue(this.players)) {
            if (i >= amount) break;
            ++i;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public int getRank(String player) {
        if (!this.players.containsKey(player = player.toLowerCase())) {
            return -1;
        }
        int i = 1;
        for (Map.Entry<String, Double> entry : this.sortByValue(this.players)) {
            if (entry.getKey().equalsIgnoreCase(player)) break;
            ++i;
        }
        return i;
    }

    private <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        return sortedEntries;
    }
}

