/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy;

import cc.leet.economy.command.BalanceCommand;
import cc.leet.economy.command.GiveMoneyCommand;
import cc.leet.economy.command.PayCommand;
import cc.leet.economy.command.SetMoneyCommand;
import cc.leet.economy.command.TakeMoneyCommand;
import cc.leet.economy.command.TopMoneyCommand;
import cc.leet.economy.util.Messages;
import cc.leet.economy.util.MoneyHandler;
import cn.nukkit.command.Command;
import cn.nukkit.plugin.PluginBase;
import java.nio.file.Files;
import java.nio.file.LinkOption;

public class Economy
extends PluginBase {
    private static Economy plugin;
    private int version;
    private MoneyHandler moneyHandler;
    private Messages messages;

    public void onEnable() {
        plugin = this;
        if (!Files.exists(this.getDataFolder().toPath(), new LinkOption[0]) && !this.getDataFolder().mkdir()) {
            this.getLogger().critical("Failed to create data folder!");
        }
        this.saveDefaultConfig();
        this.reloadSettings();
        this.moneyHandler = new MoneyHandler(plugin);
        this.messages = new Messages(plugin);
        this.getServer().getCommandMap().register("balance", (Command)new BalanceCommand(plugin));
        this.getServer().getCommandMap().register("givemoney", (Command)new GiveMoneyCommand(plugin));
        this.getServer().getCommandMap().register("pay", (Command)new PayCommand(plugin));
        this.getServer().getCommandMap().register("setmoney", (Command)new SetMoneyCommand(plugin));
        this.getServer().getCommandMap().register("takemoney", (Command)new TakeMoneyCommand(plugin));
        this.getServer().getCommandMap().register("topmoney", (Command)new TopMoneyCommand(plugin));
    }

    public void onDisable() {
        this.moneyHandler.save();
    }

    public void reloadSettings() {
        this.reloadConfig();
        this.version = (Integer)this.getConfig().get("version", (Object)1);
    }

    public static Economy getPlugin() {
        return plugin;
    }

    public MoneyHandler getAPI() {
        return this.moneyHandler;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

