/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.command;

import cc.leet.economy.Economy;
import cc.leet.economy.event.EconomyAlterMoneyEvent;
import cc.leet.economy.util.MoneyHandler;
import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Event;

public class PayCommand
extends Command {
    private Economy plugin;
    private MoneyHandler api;

    public PayCommand(Economy plugin) {
        super("pay", "Pay a player", "/pay [player] [amount]");
        this.plugin = plugin;
        this.api = plugin.getAPI();
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        double amount;
        if (!sender.hasPermission("economy.command.pay")) {
            sender.sendMessage(this.plugin.getMessages().noPermission());
            return true;
        }
        if (args.length < 2) {
            if (args.length < 2) {
                sender.sendMessage(this.plugin.getMessages().amountMissing());
            }
            if (args.length < 1) {
                sender.sendMessage(this.plugin.getMessages().playerMissing());
            }
            return true;
        }
        String target = args[0];
        if (target.equalsIgnoreCase(sender.getName())) {
            sender.sendMessage("\u00a7cYou can't pay yourself.");
            return true;
        }
        if (!this.api.exists(sender.getName())) {
            this.api.createPlayer(sender.getName());
        }
        if (!this.api.exists(target)) {
            Player player = this.plugin.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage(this.plugin.getMessages().playerNotExists());
                return true;
            }
            this.api.createPlayer(target);
        }
        try {
            amount = Double.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        if (amount <= 0.0) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        if (this.api.getBalance(sender.getName()) < amount) {
            sender.sendMessage(this.plugin.getMessages().balanceTooLow());
            return true;
        }
        if (!this.api.alterBalance(sender.getName(), -amount)) {
            sender.sendMessage("\u00a7cFailed to alter your balance!");
            return true;
        }
        if (!this.api.alterBalance(target, amount)) {
            sender.sendMessage("\u00a7cFailed to alter " + target + " balance. Please report this!");
            return true;
        }
        sender.sendMessage(this.plugin.getMessages().balanceSent(amount, amount > 1.0 ? this.api.getPlural() : this.api.getSingular(), target));
        Player t = this.plugin.getServer().getPlayer(target);
        if (t != null) {
            t.sendMessage(this.plugin.getMessages().balanceReceived(sender.getName(), amount, amount > 1.0 ? this.api.getPlural() : this.api.getSingular()));
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new EconomyAlterMoneyEvent(this.plugin, sender.getName(), target, amount, amount > 0.0));
        return true;
    }
}

