/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.command;

import cc.leet.economy.Economy;
import cc.leet.economy.event.EconomySetMoneyEvent;
import cc.leet.economy.util.MoneyHandler;
import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Event;

public class SetMoneyCommand
extends Command {
    private Economy plugin;
    private MoneyHandler api;

    public SetMoneyCommand(Economy plugin) {
        super("setmoney", "Sets the players balance", "/setmoney [player] [balance]");
        this.plugin = plugin;
        this.api = plugin.getAPI();
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        double balance;
        if (!sender.hasPermission("economy.command.setmoney")) {
            sender.sendMessage(this.plugin.getMessages().noPermission());
            return true;
        }
        if (args.length < 2) {
            if (args.length < 2) {
                sender.sendMessage(this.plugin.getMessages().amountMissing());
            }
            if (args.length < 1) {
                sender.sendMessage(this.plugin.getMessages().playerMissing());
            }
            return true;
        }
        String target = args[0];
        if (!this.api.exists(sender.getName())) {
            this.api.createPlayer(sender.getName());
        }
        if (!this.api.exists(target)) {
            Player player = this.plugin.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage(this.plugin.getMessages().playerNotExists());
                return true;
            }
            this.api.createPlayer(target);
        }
        try {
            balance = Double.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        if (balance <= 0.0) {
            sender.sendMessage(this.plugin.getMessages().amountInvalid());
            return true;
        }
        if (!this.api.setBalance(target, balance)) {
            sender.sendMessage("\u00a7cFailed to set balance for " + target + ". Please report this!");
            return true;
        }
        sender.sendMessage(this.plugin.getMessages().balanceSet(target, balance, balance > 1.0 ? this.api.getPlural() : this.api.getSingular()));
        Player t = this.plugin.getServer().getPlayer(target);
        if (t != null) {
            t.sendMessage(this.plugin.getMessages().balanceChanged(balance, balance > 1.0 ? this.api.getPlural() : this.api.getSingular(), sender.getName()));
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new EconomySetMoneyEvent(this.plugin, sender.getName(), target, balance));
        return true;
    }
}

