/*
 * Decompiled with CFR 0.152.
 */
package cc.leet.economy.command;

import cc.leet.economy.Economy;
import cc.leet.economy.util.MoneyHandler;
import cc.leet.economy.util.ToolBox;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TopMoneyCommand
extends Command {
    private Economy plugin;
    private MoneyHandler api;

    public TopMoneyCommand(Economy plugin) {
        super("topmoney", "Checks the top 3-50 richest players", "/topmoney [3-50]");
        this.plugin = plugin;
        this.api = plugin.getAPI();
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        if (!sender.hasPermission("economy.command.topmoney")) {
            sender.sendMessage(this.plugin.getMessages().noPermission());
            return true;
        }
        if (args.length > 0 && !ToolBox.isNumber(args[0])) {
            sender.sendMessage("\u00a7cOnly a whole number between 3-50 is supported.");
            return true;
        }
        int amount = args.length == 0 ? 10 : Integer.parseInt(args[0]);
        if (amount > 50 || amount < 3) {
            amount = 10;
        }
        LinkedHashMap top = this.api.getTop(amount);
        int rank = this.api.getRank(sender.getName());
        sender.sendMessage(this.plugin.getMessages().balanceRank(rank));
        int i = 1;
        Iterator iterator = top.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            sender.sendMessage(this.plugin.getMessages().balanceTop(i, entry.getKey().toString(), (Double)entry.getValue(), (Double)entry.getValue() > 1.0 ? this.api.getPlural() : this.api.getSingular()));
            ++i;
        }
        return true;
    }
}

