/*
 * Decompiled with CFR 0.152.
 */
package ru.fleynaro.floatingtext;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.FloatingTextParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import cn.nukkit.utils.TextFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Plugin
extends PluginBase
implements Listener {
    private Level level;
    private int addCount = 0;
    private Config cfg;
    private final Map<Vector3, FloatingTextParticle> texts = new HashMap<Vector3, FloatingTextParticle>();

    public void onEnable() {
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (cn.nukkit.plugin.Plugin)this);
        this.level = this.getServer().getDefaultLevel();
        this.getLogger().info(TextFormat.WHITE + "The plugin " + TextFormat.RED + "3D Floating Text" + TextFormat.WHITE + " has been loaded.");
    }

    private void loadConfig() {
        String paramName;
        String strPos;
        this.cfg = this.getConfig();
        int i = 0;
        while (!(strPos = this.cfg.getString((paramName = "texts.text" + (i + 1)) + ".pos", "not")).equals("not")) {
            double[] pos = new double[3];
            int j = 0;
            for (String coord : strPos.split(",", 3)) {
                pos[j++] = Float.parseFloat(coord);
            }
            if (pos[1] > 255.0) {
                pos[1] = (double)this.level.getHighestBlockAt((int)pos[0], (int)pos[2]) + 2.0;
            }
            this.createFloatingText(new Vector3(pos[0], pos[1], pos[2]), "", this.cfg.getString(paramName + ".text", "Not defined message"));
            ++i;
        }
    }

    private FloatingTextParticle createFloatingText(Vector3 pos, String title, String text) {
        FloatingTextParticle newFtext = new FloatingTextParticle(pos, title, TextFormat.colorize((String)text));
        this.texts.put(pos, newFtext);
        return newFtext;
    }

    private void addAllText(Player player) {
        for (FloatingTextParticle text : this.texts.values()) {
            this.level.addParticle((Particle)text, player);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.addAllText(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerExit(PlayerJoinEvent event) {
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player != null && command.getName().toLowerCase().equals("ftext") && player.hasPermission("floatingtext.create")) {
            Position pos = player.getPosition();
            int textid = this.texts.size() + 1;
            String text = args.length > 0 ? args[0] : "Your text";
            this.level.addParticle((Particle)this.createFloatingText((Vector3)pos, "", "Text" + textid + "\n" + text), player);
            this.cfg.getSection("texts").put((Object)("text" + textid), (Object)new ConfigSection((LinkedHashMap)new LinkedHashMap<String, Object>((Vector3)pos, text){
                final /* synthetic */ Vector3 val$pos;
                final /* synthetic */ String val$text;
                {
                    this.val$pos = vector3;
                    this.val$text = string;
                    this.put("pos", this.val$pos.getX() + "," + this.val$pos.getY() + "," + this.val$pos.getZ());
                    this.put("text", this.val$text);
                }
            }));
            this.cfg.save();
            player.sendMessage("The floating text" + textid + " has been created!");
        }
        return true;
    }
}

