/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions;

import cn.nukkit.command.Command;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import me.imjack.permissions.api.API;
import me.imjack.permissions.commands.RankingCommand;
import me.imjack.permissions.configuration.DataStorage;
import me.imjack.permissions.configuration.YamlStorage;
import me.imjack.permissions.group.GroupManager;
import me.imjack.permissions.listeners.PlayerListeners;

public class Main
extends PluginBase {
    private static Main instance;
    private GroupManager groupManager;
    private DataStorage dataStorage;
    private API API;

    public static Main getPlugin() {
        return instance;
    }

    public void onEnable() {
        this.getLogger().info("MadPerms is loading....");
        this.setupConfig();
        this.groupManager = new GroupManager(this.dataStorage);
        this.getServer().getOnlinePlayers().forEach((identifier, p) -> this.groupManager.getPermissionHandler().registerPlayer(p.getName(), p.addAttachment((Plugin)this)));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(this.groupManager, this, this.dataStorage.getFormat()), (Plugin)this);
        this.getServer().getCommandMap().register("ranking", (Command)new RankingCommand(this, this.groupManager));
        this.getServer().getOnlinePlayers().forEach((indentifier, p) -> this.groupManager.getPermissionHandler().registerPlayer(p.getName(), p.addAttachment((Plugin)this)));
        instance = this;
        this.API = new API(this.groupManager);
    }

    public void onDisable() {
        this.getServer().getOnlinePlayers().forEach((indentifier, p) -> this.groupManager.getPermissionHandler().unregisterPlayer(p.getName()));
        this.dataStorage.saveUsers(this.groupManager.getPermissionHandler().getPlayerData());
        instance = null;
        this.dataStorage = null;
        this.groupManager = null;
    }

    private void setupConfig() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        File file = new File(this.getDataFolder(), "permissions.yml");
        Config permissionConfig = null;
        if (!file.exists()) {
            permissionConfig = new Config(new File(this.getDataFolder(), "permissions.yml"), 2);
            permissionConfig.setNested("groups.default.", (Object)new LinkedHashMap<String, Object>(){
                {
                    this.put("options", new LinkedHashMap<String, Object>(){
                        {
                            this.put("default", true);
                            this.put("prefix", "&7[&aPlayer&7]&r ");
                            this.put("suffix", "&a");
                        }
                    });
                    this.put("permissions", new ArrayList<String>(){
                        {
                            this.add("simple.fake.permission");
                            this.add("another.fake.permission");
                        }
                    });
                }
            });
            permissionConfig.set("format", (Object)"%p%s%n&f: %m");
            permissionConfig.remove("groups.default.");
            permissionConfig.save();
        } else {
            permissionConfig = new Config(new File(this.getDataFolder(), "permissions.yml"), 2);
        }
        this.dataStorage = new YamlStorage(permissionConfig);
    }

    public API getAPI() {
        return this.API;
    }
}

