/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.group;

import cn.nukkit.permission.PermissionAttachment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.imjack.permissions.group.Group;
import me.imjack.permissions.group.GroupManager;
import me.imjack.permissions.option.Option;
import me.imjack.permissions.option.OptionValue;

public class PermissionHandler {
    private final HashMap<String, List<String>> playerData = new HashMap();
    private final HashMap<String, PermissionAttachment> perms = new HashMap();
    private Group defaultGroup;
    private GroupManager groupManager;

    public PermissionHandler(GroupManager groupManager, HashMap<String, List<String>> playerData) {
        this.groupManager = groupManager;
        Iterator<Map.Entry<String, List<String>>> entryIterator = playerData.entrySet().iterator();
        this.playerData.putAll(playerData);
        for (Group group : groupManager.getGroups()) {
            Option<?> apple;
            if (group.getOption(OptionValue.DEFAULT) == null || !(group.getOption(OptionValue.DEFAULT).getData() instanceof Boolean) || !((Boolean)(apple = group.getOption(OptionValue.DEFAULT)).getData()).booleanValue()) continue;
            this.setDefaultGroup(group);
            break;
        }
    }

    public void registerPlayer(String name, PermissionAttachment attachment) {
        if (this.perms.containsKey(name)) {
            this.unregisterPlayer(name);
        }
        this.perms.put(name, attachment);
        if (this.getPlayerData().containsKey(name)) {
            for (String groupName : this.getPlayerData().get(name)) {
                Group group = this.groupManager.getGroup(groupName);
                if (group != null) {
                    if (group.getPermissions() != null) {
                        attachment.setPermissions(group.getInheritedPermissions());
                        continue;
                    }
                    System.out.println("The group permissions for " + group.getName() + "were null");
                    continue;
                }
                attachment.getPermissions().putAll(this.defaultGroup.getPermissions());
                break;
            }
        } else {
            attachment.getPermissions().putAll(this.defaultGroup.getPermissions());
        }
    }

    public List<String> getPlayersGroups(String name) {
        if (this.playerData.containsKey(name)) {
            return this.playerData.get(name);
        }
        return Collections.singletonList(this.defaultGroup.getName());
    }

    public void unregisterPlayer(String name) {
        this.perms.remove(name);
    }

    public Group getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(Group defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public HashMap<String, List<String>> getPlayerData() {
        return this.playerData;
    }

    public Boolean setPlayerGroup(String name, Group group) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(group.getName());
        this.getPlayerData().remove(name);
        this.getPlayerData().put(name, groups);
        if (this.perms.containsKey(name)) {
            PermissionAttachment attachment = this.perms.get(name);
            attachment.clearPermissions();
            attachment.setPermissions(group.getPermissions());
        }
        return true;
    }

    public Boolean addPlayerGroup(String name, Group groupAdd) {
        List<String> groups = this.getPlayerData().get(name);
        if (groups == null) {
            groups = new ArrayList<String>();
        }
        if (!groups.contains(groupAdd.getName())) {
            groups.add(groupAdd.getName());
            this.getPlayerData().put(name, groups);
            if (this.perms.containsKey(name)) {
                PermissionAttachment attachment = this.perms.get(name);
                attachment.clearPermissions();
                for (String groupName : groups) {
                    Group group = this.groupManager.getGroup(groupName);
                    if (group == null) continue;
                    attachment.setPermissions(group.getPermissions());
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean removePlayerGroup(String name, Group groupRemove) {
        List<String> groups = this.getPlayerData().get(name);
        if (groups == null) {
            return false;
        }
        if (groups.isEmpty()) {
            return false;
        }
        if (groups.contains(groupRemove.getName())) {
            groups.remove(groupRemove.getName());
            this.getPlayerData().put(name, groups);
            if (this.perms.containsKey(name)) {
                PermissionAttachment attachment = this.perms.get(name);
                attachment.clearPermissions();
                for (String groupName : groups) {
                    Group group = this.groupManager.getGroup(groupName);
                    if (group == null) continue;
                    attachment.setPermissions(group.getPermissions());
                }
                if (groups.isEmpty()) {
                    groups.add(this.getDefaultGroup().getName());
                    attachment.setPermissions(this.getDefaultGroup().getPermissions());
                }
            }
            return true;
        }
        return false;
    }
}

