/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.commands;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import me.imjack.permissions.Main;
import me.imjack.permissions.group.Group;
import me.imjack.permissions.group.GroupManager;

public class RankingCommand
extends Command {
    private Main plugin;
    private GroupManager groupManager;

    public RankingCommand(Main plugin, GroupManager groupManager) {
        super("ranking", "Used for setting Ranks", "\u00a7cIt appears that isn't a argument for /ranking please read the documents.", new String[]{"rankings"});
        this.setPermission("mad.permissions.command.ranking");
        this.setPermissionMessage("\u00a7cYou don't have permission for this command!");
        this.plugin = plugin;
        this.groupManager = groupManager;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (sender.hasPermission(this.getPermission())) {
            if (args.length == 3) {
                Group group = this.getGroupManager().getGroup(args[2]);
                if (group == null) {
                    sender.sendMessage("\u00a7c" + args[2] + " doesn't exist.");
                    return true;
                }
                switch (args[0]) {
                    case "set": {
                        if (this.getGroupManager().getPermissionHandler().setPlayerGroup(args[1], group).booleanValue()) {
                            sender.sendMessage("\u00a7aThe player group was successfully set!");
                            break;
                        }
                        sender.sendMessage("\u00a7cThe players group was not able to be set!");
                        break;
                    }
                    case "add": {
                        if (this.getGroupManager().getPermissionHandler().addPlayerGroup(args[1], group).booleanValue()) {
                            sender.sendMessage("\u00a7aThe player was successfully added to the group!");
                            break;
                        }
                        sender.sendMessage("\u00a7cThe player was not able to be added to the group. This could be because they are already in that group!");
                        break;
                    }
                    case "remove": {
                        if (this.getGroupManager().getPermissionHandler().removePlayerGroup(args[1], group)) {
                            sender.sendMessage("\u00a7aThe player was successfully removed from the group!");
                            break;
                        }
                        sender.sendMessage("\u00a7cThe players group was not able to be removed. This could be due to them not being in that group!");
                        break;
                    }
                    default: {
                        sender.sendMessage(this.getUsage());
                        return true;
                    }
                }
                this.updatePermissions(args[1]);
                return true;
            }
            sender.sendMessage(this.getUsage());
            return true;
        }
        sender.sendMessage(this.getPermissionMessage());
        return true;
    }

    public void updatePermissions(String name) {
        Player playerArg = this.plugin.getServer().getPlayerExact(name);
        if (playerArg != null) {
            playerArg.recalculatePermissions();
        }
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }
}

