/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.configuration;

import cn.nukkit.utils.Config;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.imjack.permissions.configuration.DataStorage;
import me.imjack.permissions.group.Group;
import me.imjack.permissions.option.Option;
import me.imjack.permissions.option.OptionValue;

public class YamlStorage
implements DataStorage {
    private final Config config;

    public YamlStorage(Config config) {
        this.config = config;
    }

    @Override
    public List<Group> loadGroups() {
        LinkedHashMap groupNest = (LinkedHashMap)this.config.getNested("groups");
        if (groupNest == null) {
            return null;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Map.Entry groupData : groupNest.entrySet()) {
            Group group = new Group((String)groupData.getKey());
            LinkedHashMap dataMap = (LinkedHashMap)groupData.getValue();
            for (Map.Entry dataEntry : ((HashMap)dataMap).entrySet()) {
                switch ((String)dataEntry.getKey()) {
                    case "options": {
                        for (Map.Entry entry : ((LinkedHashMap)dataEntry.getValue()).entrySet()) {
                            OptionValue value = OptionValue.getOptionFromConfig((String)entry.getKey());
                            try {
                                group.getOptions().add((Option)value.getOptionType().getConstructors()[0].newInstance(new Object[]{value, entry.getValue()}));
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
                                exception.printStackTrace();
                            }
                        }
                        for (Iterator<Object> iterator : OptionValue.values()) {
                            if (group.getOption((OptionValue)((Object)iterator)) != null) continue;
                            try {
                                group.getOptions().add((Option)((OptionValue)((Object)iterator)).getOptionType().getConstructors()[0].newInstance(iterator, ((OptionValue)((Object)iterator)).getDefaultOption()));
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case "permissions": {
                        for (String string : (List)dataEntry.getValue()) {
                            group.addPermission(string);
                        }
                        break;
                    }
                }
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public HashMap<String, List<String>> loadUsers() {
        HashMap<String, List<String>> userData = new HashMap<String, List<String>>();
        HashMap playerData = (HashMap)this.config.getNested("users");
        if (playerData != null) {
            Set groupList = ((LinkedHashMap)this.config.getNested("groups")).keySet();
            if (groupList == null) {
                return null;
            }
            for (Map.Entry playerEntry : playerData.entrySet()) {
                for (Map.Entry dataEntry : ((LinkedHashMap)playerEntry.getValue()).entrySet()) {
                    List groups;
                    if (!((String)dataEntry.getKey()).equalsIgnoreCase("group") || (groups = ((ArrayList)dataEntry.getValue()).stream().filter(group -> groupList.contains(group)).collect(Collectors.toList())).isEmpty()) continue;
                    userData.put((String)playerEntry.getKey(), groups);
                }
            }
        }
        return userData;
    }

    @Override
    public void saveUsers(HashMap<String, List<String>> playerData) {
        LinkedHashMap<String, 1> configData = new LinkedHashMap<String, 1>();
        for (final Map.Entry<String, List<String>> data : playerData.entrySet()) {
            configData.put(data.getKey(), new LinkedHashMap<String, List<String>>(){
                {
                    this.put("group", data.getValue());
                }
            });
        }
        if (!configData.isEmpty()) {
            this.getConfig().setNested("users", configData);
            this.getConfig().remove("users.");
        }
    }

    @Override
    public String getFormat() {
        return (String)this.config.get("format");
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlStorage)) {
            return false;
        }
        YamlStorage other = (YamlStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YamlStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "YamlStorage(config=" + this.getConfig() + ")";
    }
}

