/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.imjack.permissions.option.Option;
import me.imjack.permissions.option.OptionValue;

public class Group {
    private String name;
    private HashMap<String, Boolean> permissions = new HashMap();
    private HashMap<String, Boolean> inheritedPermissions = new HashMap();
    private List<Option<?>> options = new ArrayList();

    public Group(String name) {
        this.name = name;
    }

    public Group(String name, HashMap<String, Boolean> permissions) {
        this.name = name;
        this.permissions = permissions;
    }

    public Group(String name, HashMap<String, Boolean> permissions, List<Option<?>> options) {
        this.name = name;
        this.permissions = permissions;
        this.options = options;
    }

    public void addPermission(String permission) {
        if (permission.startsWith("-")) {
            this.getPermissions().put(permission.substring(1), false);
        } else {
            this.getPermissions().put(permission, true);
        }
    }

    public Option<?> getOption(OptionValue value) {
        List options = this.getOptions().stream().filter(g -> g.getOptionValue().equals((Object)value)).collect(Collectors.toList());
        if (options == null) {
            return null;
        }
        if (options.isEmpty()) {
            return null;
        }
        return (Option)options.get(0);
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, Boolean> getPermissions() {
        return this.permissions;
    }

    public HashMap<String, Boolean> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public List<Option<?>> getOptions() {
        return this.options;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermissions(HashMap<String, Boolean> permissions) {
        this.permissions = permissions;
    }

    public void setInheritedPermissions(HashMap<String, Boolean> inheritedPermissions) {
        this.inheritedPermissions = inheritedPermissions;
    }

    public void setOptions(List<Option<?>> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        HashMap<String, Boolean> this$permissions = this.getPermissions();
        HashMap<String, Boolean> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        HashMap<String, Boolean> this$inheritedPermissions = this.getInheritedPermissions();
        HashMap<String, Boolean> other$inheritedPermissions = other.getInheritedPermissions();
        if (this$inheritedPermissions == null ? other$inheritedPermissions != null : !((Object)this$inheritedPermissions).equals(other$inheritedPermissions)) {
            return false;
        }
        List<Option<?>> this$options = this.getOptions();
        List<Option<?>> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Group;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        HashMap<String, Boolean> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        HashMap<String, Boolean> $inheritedPermissions = this.getInheritedPermissions();
        result = result * 59 + ($inheritedPermissions == null ? 43 : ((Object)$inheritedPermissions).hashCode());
        List<Option<?>> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "Group(name=" + this.getName() + ", permissions=" + this.getPermissions() + ", inheritedPermissions=" + this.getInheritedPermissions() + ", options=" + this.getOptions() + ")";
    }
}

