/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.group;

import cn.nukkit.utils.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.imjack.permissions.configuration.DataStorage;
import me.imjack.permissions.group.Group;
import me.imjack.permissions.group.PermissionHandler;
import me.imjack.permissions.option.Option;
import me.imjack.permissions.option.OptionValue;

public class GroupManager {
    private PermissionHandler permissionHandler;
    private List<Group> groups = new ArrayList<Group>();
    private Config config;

    public GroupManager(DataStorage storage) {
        this.getGroups().addAll(storage.loadGroups());
        this.getGroups().forEach(g -> g.setInheritedPermissions(this.getInheritedPermissions((Group)g)));
        this.permissionHandler = new PermissionHandler(this, storage.loadUsers());
    }

    public Group getGroup(String name) {
        for (Group group : this.getGroups()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    private HashMap<String, Boolean> getInheritedPermissions(Group groupMain) {
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
        List<Group> groups = this.getInheritedOrder(groupMain);
        for (Group group : groups) {
            perms.putAll(group.getPermissions());
        }
        perms.putAll(groupMain.getPermissions());
        return perms;
    }

    private List<Group> getInheritedOrder(Group groupMain) {
        ArrayList<Group> inheritedGroups = new ArrayList<Group>();
        Group group = this.getInheritance(groupMain);
        while (group != null) {
            inheritedGroups.add(group);
            group = this.getInheritance(group);
        }
        Collections.reverse(inheritedGroups);
        return inheritedGroups;
    }

    private Group getInheritance(Group group) {
        List options = group.getOptions().stream().filter(g -> g.getOptionValue().equals((Object)OptionValue.INHERITANCE)).collect(Collectors.toList());
        if (options == null) {
            return null;
        }
        if (options.isEmpty()) {
            return null;
        }
        if (!(((Option)options.get(0)).getData() instanceof String)) {
            System.out.println("A non string item was not added " + ((Option)options.get(0)).getData());
            return null;
        }
        String inheritedGroupName = (String)((Option)options.get(0)).getData();
        if (!inheritedGroupName.isEmpty()) {
            if (this.getGroup(inheritedGroupName) != null) {
                return this.getGroup(inheritedGroupName);
            }
            System.out.println("The group ".concat(group.getName()).concat(" cannot inherit ").concat(inheritedGroupName).concat(" as it doesn't exist"));
        }
        return null;
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setPermissionHandler(PermissionHandler permissionHandler) {
        this.permissionHandler = permissionHandler;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupManager)) {
            return false;
        }
        GroupManager other = (GroupManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PermissionHandler this$permissionHandler = this.getPermissionHandler();
        PermissionHandler other$permissionHandler = other.getPermissionHandler();
        if (this$permissionHandler == null ? other$permissionHandler != null : !this$permissionHandler.equals(other$permissionHandler)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PermissionHandler $permissionHandler = this.getPermissionHandler();
        result = result * 59 + ($permissionHandler == null ? 43 : $permissionHandler.hashCode());
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "GroupManager(permissionHandler=" + this.getPermissionHandler() + ", groups=" + this.getGroups() + ", config=" + this.getConfig() + ")";
    }
}

