/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.listeners;

import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerKickEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.TextFormat;
import java.util.List;
import me.imjack.permissions.Main;
import me.imjack.permissions.group.Group;
import me.imjack.permissions.group.GroupManager;
import me.imjack.permissions.option.OptionValue;

public class PlayerListeners
implements Listener {
    private Main plugin;
    private String format;
    private GroupManager groupManager;

    public PlayerListeners(GroupManager groupManager, Main plugin, String format) {
        this.plugin = plugin;
        this.format = format;
        this.groupManager = groupManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onJoin(PlayerJoinEvent event) {
        this.groupManager.getPermissionHandler().registerPlayer(event.getPlayer().getName(), event.getPlayer().addAttachment((Plugin)this.plugin));
        event.getPlayer().recalculatePermissions();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onQuit(PlayerQuitEvent event) {
        this.groupManager.getPermissionHandler().unregisterPlayer(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onKick(PlayerKickEvent event) {
        this.groupManager.getPermissionHandler().unregisterPlayer(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onChat(PlayerChatEvent event) {
        List<String> groups = this.groupManager.getPermissionHandler().getPlayersGroups(event.getPlayer().getName());
        System.out.println(groups);
        Group mainGroup = this.groupManager.getGroup(groups.get(groups.size() - 1));
        System.out.println(mainGroup.getName());
        event.setFormat(TextFormat.colorize((String)((String)mainGroup.getOption(OptionValue.PREFIX).getData())) + " " + event.getPlayer().getName() + event.getMessage());
        event.setFormat(TextFormat.colorize((String)this.format.replaceAll("%p", (String)mainGroup.getOption(OptionValue.PREFIX).getData()).replaceAll("%s", (String)mainGroup.getOption(OptionValue.SUFFIX).getData()).replaceAll("%n", event.getPlayer().getName()).replaceAll("%m", event.getMessage())));
    }
}

