/*
 * Decompiled with CFR 0.152.
 */
package me.imjack.permissions.option;

import me.imjack.permissions.option.Option;
import me.imjack.permissions.option.types.BooleanOption;
import me.imjack.permissions.option.types.StringOption;

public enum OptionValue {
    DEFAULT("default", false, BooleanOption.class),
    PREFIX("prefix", "", StringOption.class),
    SUFFIX("suffix", "", StringOption.class),
    INHERITANCE("inheritance", "", StringOption.class);

    private final String defaultName;
    private final Object defaultOption;
    private final Class<? extends Option<?>> optionType;

    private OptionValue(String configLine, Object defaultOption, Class<? extends Option<?>> optionType) {
        this.defaultName = configLine;
        this.defaultOption = defaultOption;
        this.optionType = optionType;
    }

    public static OptionValue getOptionFromConfig(String config) {
        for (OptionValue option : OptionValue.values()) {
            if (!config.equalsIgnoreCase(option.getDefaultName())) continue;
            return option;
        }
        return null;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public Object getDefaultOption() {
        return this.defaultOption;
    }

    public Class<? extends Option<?>> getOptionType() {
        return this.optionType;
    }
}

