/*
 * Decompiled with CFR 0.152.
 */
package me.varfalomey.zuckerman;

import cn.nukkit.utils.Config;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class YamlConfig {
    public boolean save(File f) {
        f.getParentFile().mkdirs();
        try {
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Config cfg = new Config(f, 2);
        for (Field field : this.getClass().getDeclaredFields()) {
            String path = this.getPath(field);
            try {
                cfg.set(path, field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }
        cfg.save();
        return true;
    }

    public boolean load(File f) {
        f.getParentFile().mkdirs();
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Config cfg = new Config(f, 2);
        for (Field field : this.getClass().getDeclaredFields()) {
            String path = this.getPath(field);
            try {
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    field.set(this, cfg.getInt(path, field.getInt(this)));
                    continue;
                }
                if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                    field.set(this, cfg.getBoolean(path, field.getBoolean(this)));
                    continue;
                }
                if (field.getType() == String.class) {
                    field.set(this, cfg.getString(path, (String)field.get(this)));
                    continue;
                }
                throw new UnsupportedClassVersionError("YamlConfig did not supports this class: " + field.getType().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private String getPath(Field field) {
        String path = null;
        if (field.isAnnotationPresent(Path.class)) {
            Path pathDefine = field.getAnnotation(Path.class);
            path = pathDefine.value();
        }
        if (path == null || path.isEmpty()) {
            field.getName().replaceAll("_", ".");
        }
        if (Modifier.isPrivate(field.getModifiers())) {
            field.setAccessible(true);
        }
        return path;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Path {
        public String value() default "";
    }
}

