/*
 * Decompiled with CFR 0.152.
 */
package net.skidcode.gh.pocketquery;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    public static final long ONEOVERPHI = 106039L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public byte[] array;
    public int length;
    private int position;

    public FastByteArrayOutputStream() {
        this(16);
    }

    public FastByteArrayOutputStream(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    public FastByteArrayOutputStream(byte[] a) {
        this.array = a;
    }

    public FastByteArrayOutputStream reset() {
        this.length = 0;
        this.position = 0;
        return this;
    }

    @Override
    public void write(int b) {
        if (this.position == this.length) {
            ++this.length;
            if (this.position == this.array.length) {
                this.array = FastByteArrayOutputStream.grow(this.array, this.length);
            }
        }
        this.array[this.position++] = (byte)b;
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static byte[] grow(byte[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.position + len > this.array.length) {
            this.array = FastByteArrayOutputStream.grow(this.array, this.position + len, this.position);
        }
        System.arraycopy(b, off, this.array, this.position, len);
        if (this.position + len > this.length) {
            this.length = this.position += len;
        }
    }

    public void position(long newPosition) {
        if (this.position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position too large: " + newPosition);
        }
        this.position = (int)newPosition;
    }

    public long position() {
        return this.position;
    }

    public long length() throws IOException {
        return this.length;
    }

    public byte[] toByteArray() {
        if (this.position == this.array.length) {
            return this.array;
        }
        return Arrays.copyOfRange(this.array, 0, this.position);
    }
}

