/*
 * Decompiled with CFR 0.152.
 */
package net.skidcode.gh.pocketquery;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import net.skidcode.gh.pocketquery.QueryEvent;
import net.skidcode.gh.server.Server;
import net.skidcode.gh.server.event.Event;
import net.skidcode.gh.server.event.EventRegistry;
import net.skidcode.gh.server.utils.Binary;

public class QueryHandler {
    public static final byte HANDSHAKE = 9;
    public static final byte STATISTICS = 0;
    private byte[] lastToken;
    private byte[] token;
    private byte[] longData;
    private byte[] shortData;
    private long timeout;

    public QueryHandler() {
        this.regenerateToken();
        this.lastToken = this.token;
        this.regenerateInfo();
    }

    public void regenerateInfo() {
        QueryEvent e = new QueryEvent();
        EventRegistry.handleEvent((Event)e);
        this.longData = Arrays.copyOf(e.query.array(), e.query.position());
        this.timeout = System.currentTimeMillis() + 1000L;
    }

    public void regenerateToken() {
        this.lastToken = this.token;
        byte[] token = new byte[16];
        int i = 0;
        while (i < 16) {
            token[i] = (byte)new Random().nextInt(255);
            ++i;
        }
        this.token = token;
    }

    public static String getTokenString(byte[] token, String salt) {
        return QueryHandler.getTokenString(new String(token), salt);
    }

    public static String getTokenString(String token, String salt) {
        try {
            return String.valueOf(Binary.readInt((byte[])Binary.subBytes((byte[])MessageDigest.getInstance("SHA-512").digest((String.valueOf(salt) + ":" + token).getBytes()), (int)7, (int)4)));
        }
        catch (NoSuchAlgorithmException e) {
            return String.valueOf(new Random().nextInt());
        }
    }

    public void handle(String address, int port, byte[] packet) {
        int offset = 2;
        byte packetType = packet[offset++];
        int sessionID = Binary.readInt((byte[])Binary.subBytes((byte[])packet, (int)offset, (int)4));
        byte[] payload = Binary.subBytes((byte[])packet, (int)(offset += 4));
        switch (packetType) {
            case 9: {
                byte[] reply = Binary.appendBytes((byte)9, (byte[][])new byte[][]{Binary.writeInt((int)sessionID), QueryHandler.getTokenString(this.token, address).getBytes(), new byte[1]});
                Server.handler.handler.sendRaw(address, port, reply);
                break;
            }
            case 0: {
                String token = String.valueOf(Binary.readInt((byte[])Binary.subBytes((byte[])payload, (int)0, (int)4)));
                if (!token.equals(QueryHandler.getTokenString(this.token, address)) && !token.equals(QueryHandler.getTokenString(this.lastToken, address))) break;
                if (this.timeout < System.currentTimeMillis()) {
                    this.regenerateInfo();
                }
                byte[] reply = Binary.appendBytes((byte)0, (byte[][])new byte[][]{Binary.writeInt((int)sessionID), payload.length == 8 ? this.longData : this.shortData});
                Server.handler.handler.sendRaw(address, port, reply);
            }
        }
    }
}

