/*
 * Decompiled with CFR 0.152.
 */
package PopupAlerts;

import cn.nukkit.Player;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import java.io.File;
import java.io.IOException;

public class MainClass
extends PluginBase {
    String message = "";

    public void onEnable() {
        this.createCfg();
        this.loadCfg();
        this.saveCfg();
        this.onShowPopup();
    }

    private void createCfg() {
        this.getDataFolder().mkdirs();
        File file = new File(this.getDataFolder(), "config.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadCfg() {
        Config config = this.getConfig();
        this.message = (String)config.getNested("popupalert.message", (Object)"&6Hello,&9 /username/&6!");
    }

    private void saveCfg() {
        Config config = this.getConfig();
        config.setNested("popupalert.message", (Object)"&6Hello,&9 /username/&6!");
        this.saveConfig();
    }

    public static String colorize(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length - 1; ++i) {
            if (cArray[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(cArray[i + 1]) <= -1) continue;
            cArray[i] = 167;
            cArray[i + 1] = Character.toLowerCase(cArray[i + 1]);
        }
        return new String(cArray);
    }

    private void showPopup() {
        for (Player player : this.getServer().getOnlinePlayers().values()) {
            player.sendPopup(MainClass.colorize(this.message).replace("/username/", player.getName()));
        }
    }

    private void onShowPopup() {
        this.getServer().getScheduler().scheduleDelayedTask(new Runnable(){

            @Override
            public void run() {
                MainClass.this.showPopup();
                MainClass.this.onShowPopup();
            }
        }, 10);
    }
}

