/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockChest;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.command.CommandSender;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.BlockEventPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.scheduler.Task;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.tee7even.presents.Presents;
import net.tee7even.presents.task.FirstStepTask;
import net.tee7even.presents.task.SecondStepTask;
import net.tee7even.presents.task.ThirdStepTask;
import net.tee7even.presents.utils.Message;
import net.tee7even.presents.utils.TextTagManager;

public class Chest {
    private BlockChest block;
    private Entity itemEntity;
    private int textTagId;
    private boolean inUse = false;
    private Map<String, Long> cooldownTimes = new HashMap<String, Long>();

    public Chest(double x, double y, double z, Level level, int facing) {
        this.block = new BlockChest(facing);
        this.block.x = x;
        this.block.y = y;
        this.block.z = z;
        this.block.level = level;
        level.setBlock((Vector3)this.block, (Block)this.block, true, true);
        new BlockEntityChest((FullChunk)level.getChunk((int)x >> 4, (int)z >> 4), new CompoundTag("").putList(new ListTag("Items")).putString("id", "Chest").putInt("x", (int)x).putInt("y", (int)y).putInt("z", (int)z));
    }

    public void open(Player player, Item item) {
        if (this.inUse) {
            Message.send((CommandSender)player, "in-use", new String[0]);
            return;
        }
        if (!player.getInventory().canAddItem(item)) {
            Message.send((CommandSender)player, "full-inventory", new String[0]);
            return;
        }
        if (Presents.getPlugin().getConfig().getBoolean("cooldown", true)) {
            long unixNow = Instant.now().getEpochSecond();
            if (this.cooldownTimes.containsKey(player.getName()) && unixNow - this.cooldownTimes.get(player.getName()) < (long)Presents.getPlugin().getConfig().getInt("cooldown-time", 300)) {
                Message.send((CommandSender)player, "cooldown", new String[0]);
                return;
            }
            this.cooldownTimes.put(player.getName(), unixNow);
        }
        BlockEventPacket packet = new BlockEventPacket();
        packet.x = (int)this.block.x;
        packet.y = (int)this.block.y;
        packet.z = (int)this.block.z;
        packet.case1 = 1;
        packet.case2 = 2;
        this.block.getLevel().addChunkPacket((int)this.block.x >> 4, (int)this.block.z >> 4, (DataPacket)packet);
        this.inUse = true;
        Server.getInstance().getScheduler().scheduleDelayedTask((Task)new FirstStepTask(this, (Block)this.block, item), 5);
        Server.getInstance().getScheduler().scheduleDelayedTask((Task)new SecondStepTask(this, (Block)this.block, item, player), 10);
        Server.getInstance().getScheduler().scheduleDelayedTask((Task)new ThirdStepTask(this), 200);
    }

    public void setItemEntity(Entity itemEntity) {
        this.itemEntity = itemEntity;
    }

    public void setTextTagId(int textTagId) {
        this.textTagId = textTagId;
    }

    public void close() {
        if (!this.inUse) {
            return;
        }
        TextTagManager.removeTextTag(this.textTagId);
        this.itemEntity.kill();
        this.inUse = false;
        BlockEventPacket packet = new BlockEventPacket();
        packet.x = (int)this.block.x;
        packet.y = (int)this.block.y;
        packet.z = (int)this.block.z;
        packet.case1 = 1;
        packet.case2 = 0;
        this.block.getLevel().addChunkPacket((int)this.block.x >> 4, (int)this.block.z >> 4, (DataPacket)packet);
    }

    public boolean blockEquals(Block block) {
        return this.block != null && this.block.equals((Object)block);
    }

    public boolean itemEntityEquals(EntityItem itemEntity) {
        return this.itemEntity != null && this.itemEntity.equals((Object)itemEntity);
    }
}

